/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.bookmarks;

import java.io.IOException;
import java.io.Writer;
import net.incongru.berkano.bookmarks.Bookmark;
import net.incongru.berkano.bookmarks.BookmarksTree;
import net.incongru.berkano.bookmarks.SimpleBookmarksWriter;
import net.incongru.berkano.tree.SimpleTreeWriter;
import net.incongru.berkano.tree.TreeWriter;

public class HtmlListBookmarksWriter
extends SimpleBookmarksWriter {
    private int lastIndentLevel;

    public void write(BookmarksTree bookmarksTree, Writer out) throws IOException {
        this.lastIndentLevel = 0;
        out.write("<ul>\n");
        super.write(bookmarksTree, out);
        while (this.lastIndentLevel >= 0) {
            out.write("</ul>\n");
            --this.lastIndentLevel;
        }
    }

    protected void writeBookmark(Bookmark bookmark, Writer out) throws IOException {
        out.write("<li>");
        out.write("<a href=\"");
        out.write(bookmark.getLink());
        out.write("\" title=\"");
        out.write(bookmark.getDescription());
        out.write("\">");
        out.write(bookmark.getDescription());
        out.write("</a>");
        out.write("</li>");
    }

    protected TreeWriter getTreeWriter() {
        return new SimpleTreeWriter(){

            protected void writeObject(Object nodeObject, Writer out) throws IOException {
                Bookmark bookmark = (Bookmark)nodeObject;
                HtmlListBookmarksWriter.this.writeBookmark(bookmark, out);
            }

            protected void indent(Writer out, int level) throws IOException {
                HtmlListBookmarksWriter.this.htmlListIndent(out, level);
            }
        };
    }

    protected void htmlListIndent(Writer out, int level) throws IOException {
        if (level > this.lastIndentLevel) {
            out.write("<ul>\n");
        } else if (level < this.lastIndentLevel) {
            out.write("</ul>\n");
        }
        this.lastIndentLevel = level;
    }
}

