/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.beantag;

import net.incongru.beantag.AbstractTableWriter;
import net.incongru.beantag.PropertyDecoratorException;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.log4j.Logger;

public class OgnlTableWriter
extends AbstractTableWriter {
    private static final Logger logger = Logger.getLogger((Class)OgnlTableWriter.class);

    protected Object lookupValue(String propertyName, Object o) throws PropertyDecoratorException {
        try {
            Object value = null;
            Object ognlExpr = Ognl.parseExpression((String)propertyName);
            if (this.propertyDecorator != null) {
                this.propertyDecorator.setCurrentItem(o);
                try {
                    value = Ognl.getValue((Object)ognlExpr, (Object)this.propertyDecorator);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
            }
            if (value == null) {
                value = Ognl.getValue((Object)ognlExpr, (Object)o);
            }
            return value;
        }
        catch (OgnlException e) {
            logger.warn((Object)("Can't get property[" + propertyName + "] for [" + o + "]: " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            return null;
        }
    }

    public boolean evaluate(String expr, Object o) {
        try {
            Object ognlExpr = Ognl.parseExpression((String)expr);
            Boolean result = (Boolean)Ognl.getValue((Object)ognlExpr, (Object)o, (Class)Boolean.class);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (OgnlException e) {
            logger.warn((Object)("Can't evaluate expression[" + expr + "]"), (Throwable)e);
            return false;
        }
    }
}

