/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.beantag;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.incongru.beantag.BeanTagConfig;
import net.incongru.beantag.Property;
import net.incongru.beantag.PropertyDecorator;
import net.incongru.beantag.PropertyDecoratorException;
import net.incongru.beantag.TableWriter;
import org.apache.commons.beanutils.BeanUtils;

public class BeanDisplayTag
extends SimpleTagSupport {
    private Object bean;
    private String name;
    private String label;
    private String showNulls;
    private String writerClass;
    private String decoratorClass;
    private String htmlTableClass;
    private String htmlTableStyle;
    private String htmlTableId;
    private String keyCssStyle;
    private String keyCssClass;
    private String valueCssStyle;
    private String valueCssClass;
    private Collection properties;
    private TableWriter tableWriter;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setShownulls(String showNulls) {
        this.showNulls = showNulls;
    }

    public void setWriter(String writerClass) {
        this.writerClass = writerClass;
    }

    public void setDecorator(String decoratorClass) {
        this.decoratorClass = decoratorClass;
    }

    public void setCssclass(String htmlTableClass) {
        this.htmlTableClass = htmlTableClass;
    }

    public void setStyle(String htmlTableStyle) {
        this.htmlTableStyle = htmlTableStyle;
    }

    public void setId(String htmlTableId) {
        this.htmlTableId = htmlTableId;
    }

    public void setKeyclass(String keyCssClass) {
        this.keyCssClass = keyCssClass;
    }

    public void setKeystyle(String keyCssStyle) {
        this.keyCssStyle = keyCssStyle;
    }

    public void setValueclass(String valueCssClass) {
        this.valueCssClass = valueCssClass;
    }

    public void setValuestyle(String valueCssStyle) {
        this.valueCssStyle = valueCssStyle;
    }

    void addProperty(Property prop) {
        this.properties.add(prop);
    }

    public void doTag() throws JspException, IOException {
        BeanTagConfig config = BeanTagConfig.getConfig((PageContext)this.getJspContext());
        if (this.bean != null && this.name != null) {
            throw new JspException("Only one of bean or name attributes is supported.");
        }
        if (this.bean == null && this.name == null) {
            throw new JspException("You must define at least one of 'bean' or 'name' attribute.");
        }
        if (this.bean == null) {
            this.bean = this.getJspContext().findAttribute(this.name);
        }
        if (this.writerClass != null) {
            this.tableWriter = config.instanciateWriter(this.writerClass);
            this.writerClass = null;
        } else {
            this.tableWriter = config.instanciateDefaultWriter();
        }
        if (this.decoratorClass != null) {
            PropertyDecorator decorator = config.instanciatePropertyDecorator(this.decoratorClass);
            this.tableWriter.setPropertyDecorator(decorator);
            this.decoratorClass = null;
        }
        try {
            this.properties = new LinkedList();
            JspFragment jspBody = this.getJspBody();
            if (jspBody != null) {
                jspBody.invoke((Writer)this.getJspContext().getOut());
            }
            if (this.properties.size() == 0) {
                this.getAllProperties();
            }
            JspWriter out = this.getJspContext().getOut();
            this.tableWriter.writeHeader(out, this.label, this.htmlTableClass, this.htmlTableStyle, this.htmlTableId);
            this.rows(out);
            this.tableWriter.writeFooter(out);
            out.flush();
        }
        catch (PropertyDecoratorException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private void getAllProperties() throws JspException, PropertyDecoratorException {
        try {
            ArrayList all = new ArrayList(BeanUtils.describe((Object)this.bean).keySet());
            Collections.sort(all);
            Iterator it = all.iterator();
            while (it.hasNext()) {
                String propName = (String)it.next();
                this.addProperty(new Property(this.getValue(propName), propName, propName, null, null, null));
            }
        }
        catch (IllegalAccessException ex) {
            throw new JspException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new JspException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new JspException((Throwable)ex);
        }
    }

    private void rows(JspWriter out) throws IOException, JspException {
        Iterator it = this.properties.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            try {
                String expr = prop.getCondition();
                if (expr != null && !this.evalCondition(expr, this.bean)) continue;
                Object value = prop.getValue();
                if ("skip".equals(this.showNulls) && value == null) continue;
                out.print("<tr");
                String s = this.tableWriter.getRowClass(prop, this.bean);
                if (s != null) {
                    out.print(" class=\"");
                    out.print(s);
                    out.print("\"");
                }
                if ((s = this.tableWriter.getRowStyle(prop, this.bean)) != null) {
                    out.print(" style=\"");
                    out.print(s);
                    out.print("\"");
                }
                out.println(">");
                out.print("<td");
                s = this.tableWriter.getLabelClass(prop, this.bean);
                if (s != null || this.keyCssClass != null) {
                    out.print(" class=\"");
                    out.print(this.silentNull(s));
                    if (s != null && this.keyCssClass != null) {
                        out.print(" ");
                    }
                    out.print(this.silentNull(this.keyCssClass));
                    out.print("\"");
                }
                if ((s = this.tableWriter.getLabelStyle(prop, this.bean)) != null || this.keyCssStyle != null) {
                    out.print(" style=\"");
                    out.print(this.silentNull(s));
                    if (s != null && this.keyCssStyle != null) {
                        out.print(" ");
                    }
                    out.print(this.silentNull(this.keyCssStyle));
                    out.print("\"");
                }
                out.print(">");
                out.print(this.tableWriter.getLabel(prop));
                out.println("</td>");
                out.print("<td");
                s = this.tableWriter.getValueClass(prop, this.bean);
                if (s != null || this.valueCssClass != null) {
                    out.print(" class=\"");
                    out.print(this.silentNull(s));
                    if (s != null && this.valueCssClass != null) {
                        out.print(" ");
                    }
                    out.print(this.silentNull(this.valueCssClass));
                    out.print("\"");
                }
                if ((s = this.tableWriter.getValueStyle(prop, this.bean)) != null || this.valueCssStyle != null) {
                    out.print(" style=\"");
                    out.print(this.silentNull(s));
                    if (s != null && this.valueCssStyle != null) {
                        out.print(" ");
                    }
                    out.print(this.silentNull(this.valueCssStyle));
                    out.print("\"");
                }
                out.print(">");
                if (value != null) {
                    out.print(value);
                } else if ("true".equals(this.showNulls)) {
                    out.print("null");
                }
                out.println("</td>");
                out.println("</tr>");
            }
            catch (PropertyDecoratorException ex) {
                throw new JspException("Can't read property[" + prop + "] for [" + this.bean + "]: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    Object getValue(String propertyName) throws PropertyDecoratorException {
        return this.tableWriter.getValue(propertyName, this.bean);
    }

    private boolean evalCondition(String condition, Object o) {
        return this.tableWriter.evaluate(condition, o);
    }

    private String silentNull(String s) {
        return s != null ? s : "";
    }
}

