/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.wsdl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.beehive.wsm.jsr181.model.SOAPBindingInfo;
import org.apache.beehive.wsm.jsr181.model.WebServiceMETHODMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServicePARAMETERMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TBindingOperation;
import org.xmlsoap.schemas.wsdl.TBindingOperationMessage;
import org.xmlsoap.schemas.wsdl.TDefinitions;
import org.xmlsoap.schemas.wsdl.TMessage;
import org.xmlsoap.schemas.wsdl.TOperation;
import org.xmlsoap.schemas.wsdl.TParam;
import org.xmlsoap.schemas.wsdl.TPart;
import org.xmlsoap.schemas.wsdl.TPort;
import org.xmlsoap.schemas.wsdl.TPortType;
import org.xmlsoap.schemas.wsdl.TService;
import org.xmlsoap.schemas.wsdl.soap.AddressDocument;
import org.xmlsoap.schemas.wsdl.soap.BindingDocument;
import org.xmlsoap.schemas.wsdl.soap.BodyDocument;
import org.xmlsoap.schemas.wsdl.soap.OperationDocument;
import org.xmlsoap.schemas.wsdl.soap.TAddress;
import org.xmlsoap.schemas.wsdl.soap.TBinding;
import org.xmlsoap.schemas.wsdl.soap.TBody;
import org.xmlsoap.schemas.wsdl.soap.TStyleChoice;
import org.xmlsoap.schemas.wsdl.soap.UseChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLProcessor {
    public static final String TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAPENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String WSDLNS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String WSDLSOAPNS = "http://schemas.xmlsoap.org/wsdl/soap/";

    public static WebServiceTYPEMetadata toWebServiceMetadata(DefinitionsDocument defDoc) throws IllegalAccessException, NoSuchFieldException {
        WebServiceTYPEMetadata wsm = new WebServiceTYPEMetadata(null);
        HashMap<String, WebServiceMETHODMetadata> methodMap = new HashMap<String, WebServiceMETHODMetadata>();
        TDefinitions defs = defDoc.getDefinitions();
        HashMap<String, TPart[]> messageMap = new HashMap<String, TPart[]>();
        if (defs.sizeOfMessageArray() > 0) {
            TMessage[] messages;
            for (TMessage msg : messages = defs.getMessageArray()) {
                messageMap.put(msg.getName(), msg.getPartArray());
            }
        }
        if (defs.sizeOfPortTypeArray() > 0) {
            TOperation[] operations;
            TPortType tP = defs.getPortTypeArray(0);
            wsm.setWsName(tP.getName());
            for (TOperation op : operations = tP.getOperationArray()) {
                WSDLProcessor.processTOperation(op, wsm, methodMap, messageMap);
            }
        }
        if (defs.sizeOfBindingArray() > 0) {
            org.xmlsoap.schemas.wsdl.TBinding tBind = defs.getBindingArray(0);
            WSDLProcessor.processTBinding(tBind, wsm, methodMap);
        }
        if (defs.sizeOfServiceArray() > 0) {
            wsm.setWsServiceName(defs.getServiceArray(0).getName());
        }
        return wsm;
    }

    public static DefinitionsDocument fromWebServiceMetadata(WebServiceTYPEMetadata wsm) throws Exception {
        String ns = wsm.getWsTargetNamespace();
        DefinitionsDocument defDoc = DefinitionsDocument.Factory.newInstance();
        TDefinitions tDefs = defDoc.addNewDefinitions();
        TPortType tPT = tDefs.addNewPortType();
        tPT.setName(wsm.getWsName());
        org.xmlsoap.schemas.wsdl.TBinding tBind = tDefs.addNewBinding();
        tBind.setName(tPT.getName() + "Binding");
        tBind.setType(new QName(ns, tPT.getName()));
        BindingDocument bindDoc = BindingDocument.Factory.newInstance();
        TBinding tSoapBind = bindDoc.addNewBinding();
        if (SOAPBinding.Style.DOCUMENT.equals((Object)wsm.getSoapBinding().getStyle())) {
            tSoapBind.setStyle(TStyleChoice.DOCUMENT);
        } else {
            tSoapBind.setStyle(TStyleChoice.RPC);
        }
        tSoapBind.setTransport(TRANSPORT);
        WSDLProcessor.insertChild((XmlObject)tBind, (XmlObject)bindDoc);
        WSDLProcessor.processMethodMetadata(wsm.getMethods(), tDefs, tPT, tBind, ns);
        TService tServ = tDefs.addNewService();
        tServ.setName(wsm.getWsServiceName());
        TPort tPort = tServ.addNewPort();
        tPort.setName(wsm.getWsName());
        tPort.setBinding(new QName(ns, tBind.getName()));
        AddressDocument addrDoc = AddressDocument.Factory.newInstance();
        TAddress tAddr = addrDoc.addNewAddress();
        tAddr.setLocation("fake://FAKEURL");
        WSDLProcessor.insertChild((XmlObject)tPort, (XmlObject)tAddr);
        return defDoc;
    }

    private static void processTOperation(TOperation op, WebServiceTYPEMetadata wsm, Map<String, WebServiceMETHODMetadata> methodMap, Map<String, TPart[]> messageMap) {
        TPart[] returnTypes;
        String opName = op.getName();
        TParam outputParam = op.getOutput();
        Class<Void> returnType = Void.TYPE;
        if (outputParam != null && (returnTypes = messageMap.get(outputParam.getMessage().getLocalPart())).length > 0) {
            String returnName = returnTypes[0].getName();
            QName qReturnType = returnTypes[0].getType();
            returnType = null;
        }
        WebServiceMETHODMetadata wmm = new WebServiceMETHODMetadata(opName, returnType);
        wmm.setWmOperationName(opName);
        methodMap.put(opName, wmm);
        List paramOrder = op.getParameterOrder();
        if (paramOrder != null) {
            TParam inputParam = op.getInput();
            TPart[] parameters = messageMap.get(inputParam.getMessage().getLocalPart());
            block0: for (Object ord : paramOrder) {
                for (TPart currentParam : parameters) {
                    if (!ord.equals(currentParam.getName())) continue;
                    QName qParamType = currentParam.getType();
                    WebServicePARAMETERMetadata wpm = new WebServicePARAMETERMetadata();
                    wpm.setWpName((String)ord);
                    wpm.setWpMode(WebParam.Mode.IN);
                    wmm.addParam(wpm);
                    continue block0;
                }
            }
        }
        wsm.addMethod(wmm);
    }

    private static void processTBinding(org.xmlsoap.schemas.wsdl.TBinding tBind, WebServiceTYPEMetadata wsm, Map<String, WebServiceMETHODMetadata> methodMap) throws IllegalAccessException, NoSuchFieldException {
        TBindingOperation[] tBops;
        TBinding[] soapBinding = WSDLProcessor.getSOAPBinding(tBind);
        SOAPBindingInfo soapInfo = new SOAPBindingInfo();
        if (TStyleChoice.DOCUMENT.equals(soapBinding[0].getStyle())) {
            soapInfo.setStyle(SOAPBinding.Style.DOCUMENT);
        } else {
            soapInfo.setStyle(SOAPBinding.Style.RPC);
        }
        wsm.setSoapBinding(soapInfo);
        for (TBindingOperation tBop : tBops = tBind.getOperationArray()) {
            TBody[] bodies;
            TBindingOperationMessage tbMsg;
            WebServiceMETHODMetadata wmm = methodMap.get(tBop.getName());
            org.xmlsoap.schemas.wsdl.soap.TOperation[] soapOperations = WSDLProcessor.getSOAPOperations(tBop);
            if (soapOperations.length > 0) {
                wmm.setWmAction(soapOperations[0].getSoapAction());
                if (TStyleChoice.DOCUMENT.equals(soapOperations[0].getStyle())) {
                    soapInfo = new SOAPBindingInfo();
                    soapInfo.setStyle(SOAPBinding.Style.DOCUMENT);
                } else if (TStyleChoice.RPC.equals(soapOperations[0].getStyle())) {
                    soapInfo = new SOAPBindingInfo();
                    soapInfo.setStyle(SOAPBinding.Style.RPC);
                }
            }
            if ((tbMsg = tBop.getInput()) == null) {
                tbMsg = tBop.getOutput();
            }
            if (tbMsg == null || (bodies = WSDLProcessor.getSOAPBody(tbMsg)).length <= 0) continue;
            if (wsm.getWsTargetNamespace() == null) {
                wsm.setWsTargetNamespace(bodies[0].getNamespace());
            }
            if (UseChoice.LITERAL.equals(bodies[0].getUse())) {
                soapInfo.setUse(SOAPBinding.Use.LITERAL);
                continue;
            }
            soapInfo.setUse(SOAPBinding.Use.ENCODED);
        }
    }

    private static void processMethodMetadata(Collection<WebServiceMETHODMetadata> methods, TDefinitions defs, TPortType portType, org.xmlsoap.schemas.wsdl.TBinding bind, String namespace) {
        for (WebServiceMETHODMetadata op : methods) {
            String operationName = op.getWmOperationName();
            String request = operationName + "Request";
            String response = operationName + "Response";
            TMessage tMsg = defs.addNewMessage();
            tMsg.setName(request);
            ArrayList<String> paramOrder = new ArrayList<String>();
            WSDLProcessor.processParameterMetadata(op.getParams(), paramOrder, tMsg);
            if (!op.isOneWay()) {
                tMsg = defs.addNewMessage();
                tMsg.setName(response);
                TPart tPart = tMsg.addNewPart();
                tPart.setName(op.getWrName());
                tPart.setType(WSDLProcessor.class2QName(op.getJavaReturnType()));
            }
            TOperation tOp = portType.addNewOperation();
            tOp.setName(operationName);
            tOp.setParameterOrder(paramOrder);
            TParam input = tOp.addNewInput();
            TParam output = tOp.addNewOutput();
            input.setName(request);
            input.setMessage(new QName(namespace, request));
            if (!op.isOneWay()) {
                output.setName(response);
                output.setMessage(new QName(namespace, response));
            }
            WSDLProcessor.processBindingOperationMetadata(bind.addNewOperation(), op, namespace, operationName, request, response);
        }
    }

    private static void processParameterMetadata(Collection<WebServicePARAMETERMetadata> params, List<String> paramOrder, TMessage msg) {
        for (WebServicePARAMETERMetadata param : params) {
            TPart tPart = msg.addNewPart();
            tPart.setName(param.getWpName());
            tPart.setType(WSDLProcessor.class2QName(param.getJavaType()));
            paramOrder.add(param.getWpName());
        }
    }

    private static void processBindingOperationMetadata(TBindingOperation tBop, WebServiceMETHODMetadata op, String namespace, String operationName, String request, String response) {
        tBop.setName(operationName);
        OperationDocument opDoc = OperationDocument.Factory.newInstance();
        org.xmlsoap.schemas.wsdl.soap.TOperation tSoapOperation = opDoc.addNewOperation();
        tSoapOperation.setSoapAction(op.getWmAction());
        WSDLProcessor.insertChild((XmlObject)tBop, (XmlObject)opDoc);
        TBindingOperationMessage inBom = tBop.addNewInput();
        TBindingOperationMessage outBom = tBop.addNewOutput();
        inBom.setName(request);
        outBom.setName(response);
        BodyDocument bodDoc = BodyDocument.Factory.newInstance();
        TBody tBod = bodDoc.addNewBody();
        tBod.setNamespace(namespace);
        ArrayList<String> encodingStyles = new ArrayList<String>();
        encodingStyles.add(SOAPENCODING);
        tBod.setEncodingStyle(encodingStyles);
        WSDLProcessor.insertChild((XmlObject)inBom, (XmlObject)bodDoc);
        WSDLProcessor.insertChild((XmlObject)outBom, (XmlObject)bodDoc);
    }

    public static boolean insertChild(XmlObject parent, XmlObject child) {
        XmlCursor kidCursor = child.newCursor();
        XmlCursor parentCursor = parent.newCursor();
        parentCursor.toFirstContentToken();
        kidCursor.toNextToken();
        return kidCursor.copyXml(parentCursor);
    }

    public static WebServiceTYPEMetadata loadWebServiceMetadataFromWSDL(String wsdlLocation) throws IOException, XmlException, IllegalAccessException, NoSuchFieldException {
        return WSDLProcessor.toWebServiceMetadata(WSDLProcessor.parseWSDL(wsdlLocation));
    }

    public static DefinitionsDocument parseWSDL(String wsdlLocation) throws IOException, MalformedURLException, XmlException {
        if (wsdlLocation.indexOf("://") > 2) {
            return WSDLProcessor.parseWSDL(new URL(wsdlLocation));
        }
        return WSDLProcessor.parseWSDL(new File(wsdlLocation));
    }

    public static DefinitionsDocument parseWSDL(File wsdlFile) throws IOException, XmlException {
        return DefinitionsDocument.Factory.parse((File)wsdlFile);
    }

    public static DefinitionsDocument parseWSDL(URL wsdlURL) throws IOException, MalformedURLException, XmlException {
        return DefinitionsDocument.Factory.parse((URL)wsdlURL);
    }

    public static org.xmlsoap.schemas.wsdl.soap.TOperation[] getSOAPOperations(TBindingOperation bo) throws IllegalAccessException, NoSuchFieldException {
        return (org.xmlsoap.schemas.wsdl.soap.TOperation[])WSDLProcessor.selectChildren((XmlObject)bo, org.xmlsoap.schemas.wsdl.soap.TOperation.class);
    }

    public static TBinding[] getSOAPBinding(org.xmlsoap.schemas.wsdl.TBinding b) throws IllegalAccessException, NoSuchFieldException {
        return (TBinding[])WSDLProcessor.selectChildren((XmlObject)b, TBinding.class);
    }

    public static TBody[] getSOAPBody(TBindingOperationMessage bom) throws IllegalAccessException, NoSuchFieldException {
        return (TBody[])WSDLProcessor.selectChildren((XmlObject)bom, TBody.class);
    }

    public static TAddress[] getSOAPAddress(TPort port) throws IllegalAccessException, NoSuchFieldException {
        return (TAddress[])WSDLProcessor.selectChildren((XmlObject)port, TAddress.class);
    }

    private static <T extends XmlObject> T[] selectChildren(XmlObject parent, Class<T> childClass) throws IllegalAccessException, NoSuchFieldException {
        SchemaType st = (SchemaType)childClass.getField("type").get(null);
        XmlObject[] kids = parent.selectChildren(st.getDocumentElementName());
        XmlObject[] castKids = (XmlObject[])Array.newInstance(childClass, kids.length);
        for (int j = 0; j < castKids.length; ++j) {
            castKids[j] = (XmlObject)childClass.cast(kids[j]);
        }
        return castKids;
    }

    public static QName class2QName(String typeName) {
        if (typeName == null) {
            return new QName("java", "UnknownType");
        }
        int lastDot = typeName.lastIndexOf(46);
        return new QName(typeName.substring(0, lastDot), typeName.substring(lastDot + 1));
    }

    public static QName class2QName(Class type) {
        if (type == null) {
            return new QName("java", "UnknownType");
        }
        String packageName = type.getPackage().getName();
        String className = type.getName();
        className = className.substring(packageName.length());
        return new QName(packageName, className);
    }
}

