/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.processor.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.apache.beehive.wsm.jsr181.model.AnnotationModel;
import org.apache.beehive.wsm.jsr181.model.WebServiceMETHODMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServicePARAMETERMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsmReflectionAnnotationProcessor {
    private static WsmReflectionAnnotationProcessor _instance;

    private WsmReflectionAnnotationProcessor() {
    }

    public static WsmReflectionAnnotationProcessor getInstance() {
        if (null == _instance) {
            _instance = new WsmReflectionAnnotationProcessor();
        }
        return _instance;
    }

    public AnnotationModel getObjectModel(Class sibClass) {
        return this.getWebServiceTYPEMetadata(sibClass);
    }

    protected WebServiceTYPEMetadata getWebServiceTYPEMetadata(Class sibClass) {
        List<Annotation> annotations;
        if (null == sibClass) {
            return null;
        }
        WebService wsAnnotation = sibClass.getAnnotation(WebService.class);
        if (null == wsAnnotation) {
            return null;
        }
        boolean hasServiceEndpointInterface = false;
        if (null != wsAnnotation.endpointInterface() && 0 < wsAnnotation.endpointInterface().length()) {
            hasServiceEndpointInterface = true;
        }
        ArrayList<WebServiceMETHODMetadata> webMethods = new ArrayList<WebServiceMETHODMetadata>();
        if (hasServiceEndpointInterface) {
            try {
                Class<?> seiClass = Class.forName(wsAnnotation.endpointInterface());
                for (Method method : Arrays.asList(seiClass.getMethods())) {
                    webMethods.add(this.getWebServiceMETHODMetadata(method));
                }
                annotations = Arrays.asList(seiClass.getAnnotations());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        } else {
            for (Method method : sibClass.getMethods()) {
                if (!AnnotationModel.hasAnnotationType(Arrays.asList(method.getAnnotations()), WebMethod.class)) continue;
                webMethods.add(this.getWebServiceMETHODMetadata(method));
            }
            annotations = Arrays.asList(sibClass.getAnnotations());
        }
        WebServiceTYPEMetadata wstm = null;
        try {
            wstm = new WebServiceTYPEMetadata(sibClass.getAnnotation(WebService.class), sibClass.getName(), annotations, webMethods);
            wstm.validate();
        }
        catch (Throwable t) {
            t.printStackTrace();
            wstm = null;
        }
        return wstm;
    }

    protected WebServiceMETHODMetadata getWebServiceMETHODMetadata(Method method) {
        ArrayList<WebServicePARAMETERMetadata> webParams = new ArrayList<WebServicePARAMETERMetadata>();
        Annotation[][] allAnnotations = method.getParameterAnnotations();
        int offset = 0;
        for (Class<?> paramType : method.getParameterTypes()) {
            webParams.add(this.getWebServicePARAMETERMetadata(paramType, offset, Arrays.asList(allAnnotations[offset])));
            ++offset;
        }
        WebServiceMETHODMetadata wsmm = null;
        try {
            wsmm = new WebServiceMETHODMetadata(method.getName(), method.getReturnType(), 0 < method.getExceptionTypes().length, Arrays.asList(method.getAnnotations()), webParams);
        }
        catch (Throwable t) {
            t.printStackTrace();
            wsmm = null;
        }
        return wsmm;
    }

    protected WebServicePARAMETERMetadata getWebServicePARAMETERMetadata(Class paramType, int offset, List<Annotation> annotations) {
        WebServicePARAMETERMetadata wspm = null;
        try {
            wspm = new WebServicePARAMETERMetadata(paramType, "in" + offset, annotations);
        }
        catch (Throwable t) {
            t.printStackTrace();
            wspm = null;
        }
        return wspm;
    }
}

