/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.processor.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.apache.beehive.wsm.jsr181.model.AnnotationModel;
import org.apache.beehive.wsm.jsr181.model.WebServiceMETHODMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServicePARAMETERMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;
import org.apache.beehive.wsm.jsr181.processor.ProcessorException;
import org.apache.beehive.wsm.jsr181.processor.apt.TwoPhaseAnnotationProcessor;
import org.apache.beehive.wsm.jsr181.processor.apt.TypeMirrorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsmAnnotationProcessor
extends TwoPhaseAnnotationProcessor {
    private static Map<String, AnnotationModel> objectModels = new HashMap<String, AnnotationModel>();

    public WsmAnnotationProcessor(Set<AnnotationTypeDeclaration> _atds, AnnotationProcessorEnvironment _env) {
        super(_atds, _env);
    }

    @Override
    public void check(Declaration decl) {
        if (null != decl) {
            return;
        }
        if (null == decl) {
            throw new ProcessorException("Declaration type \"null\" not allowed");
        }
        if (!(decl instanceof ClassDeclaration) && !(decl instanceof InterfaceDeclaration)) {
            return;
        }
        WebService ws = (WebService)decl.getAnnotation(WebService.class);
        if (null == ws) {
            throw new ProcessorException("@WebService annotation missing in source file");
        }
        if (0 == ws.endpointInterface().length()) {
            this.checkObjectModel((TypeDeclaration)decl, ws);
        } else {
            try {
                Class<?> seiClass = Class.forName(ws.endpointInterface());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void generate(Declaration decl) {
    }

    protected AnnotationModel checkObjectModel(TypeDeclaration decl, WebService ws) {
        ArrayList<WebServiceMETHODMetadata> webMethods = new ArrayList<WebServiceMETHODMetadata>();
        for (MethodDeclaration methodDecl : decl.getMethods()) {
            if (null == methodDecl.getAnnotation(WebMethod.class)) continue;
            webMethods.add(this.getWebServiceMETHODMetadata(methodDecl));
        }
        WebServiceTYPEMetadata wstm = null;
        try {
            Collection<Annotation> annotations = this.getAnnotations((Declaration)decl);
            wstm = new WebServiceTYPEMetadata((WebService)AnnotationModel.getAnnotationOfType(annotations, WebService.class), decl.getQualifiedName(), annotations, webMethods);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return wstm;
    }

    protected WebServiceMETHODMetadata getWebServiceMETHODMetadata(MethodDeclaration decl) {
        ArrayList<WebServicePARAMETERMetadata> webParams = new ArrayList<WebServicePARAMETERMetadata>();
        for (ParameterDeclaration paramDecl : decl.getParameters()) {
            webParams.add(this.getWebServicePARAMETERMetadata(paramDecl));
        }
        WebServiceMETHODMetadata wsmm = null;
        try {
            Collection<Annotation> annotations = this.getAnnotations((Declaration)decl);
            wsmm = new WebServiceMETHODMetadata(decl.getSimpleName(), TypeMirrorUtil.classForName(decl.getReturnType()), 0 < decl.getThrownTypes().size(), annotations, webParams);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return wsmm;
    }

    protected WebServicePARAMETERMetadata getWebServicePARAMETERMetadata(ParameterDeclaration decl) {
        WebServicePARAMETERMetadata wspm = null;
        try {
            Collection<Annotation> annotations = this.getAnnotations((Declaration)decl);
            wspm = new WebServicePARAMETERMetadata(TypeMirrorUtil.classForName(decl.getType()), decl.getSimpleName(), annotations);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return wspm;
    }

    private Collection<Annotation> getAnnotations(Declaration decl) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (AnnotationMirror am : decl.getAnnotationMirrors()) {
            AnnotationType at = am.getAnnotationType();
            try {
                Class<?> clazz = Class.forName(at.getDeclaration().getQualifiedName());
                Annotation a = decl.getAnnotation(clazz);
                if (null == a) continue;
                annotations.add(a);
            }
            catch (ClassNotFoundException e) {}
        }
        return annotations;
    }

    public static AnnotationModel getObjectModel(String name) {
        return objectModels.get(name);
    }

    public static Set<String> getObjectModelNames() {
        return objectModels.keySet();
    }
}

