/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.processor.apt;

import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;

public class TypeMirrorUtil {
    public static Class classForName(TypeMirror type) throws ClassNotFoundException {
        if (type instanceof PrimitiveType) {
            return TypeMirrorUtil.getPrimitiveClass(((PrimitiveType)type).getKind());
        }
        if (type instanceof VoidType) {
            return Void.TYPE;
        }
        if (type instanceof ArrayType) {
            Object[] typeOfArray = new Object[]{new Object()};
            int arrayDepth = TypeMirrorUtil.arrayDepth((ArrayType)type, 0, typeOfArray);
            StringBuffer className = new StringBuffer();
            for (int i = 0; i < arrayDepth; ++i) {
                className.append("[");
            }
            TypeMirror mirrorTypeOfArray = (TypeMirror)typeOfArray[0];
            if (mirrorTypeOfArray instanceof PrimitiveType) {
                className.append(TypeMirrorUtil.getTypeSignatureOfPrimitiveType(((PrimitiveType)mirrorTypeOfArray).getKind()));
            } else {
                className.append("L").append(((TypeMirror)typeOfArray[0]).toString()).append(";");
            }
            return Class.forName(className.toString());
        }
        return Class.forName(type.toString());
    }

    private static Class getPrimitiveClass(PrimitiveType.Kind kind) {
        switch (kind) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
        }
        return null;
    }

    private static String getTypeSignatureOfPrimitiveType(PrimitiveType.Kind kind) {
        switch (kind) {
            case BOOLEAN: {
                return "Z";
            }
            case BYTE: {
                return "B";
            }
            case CHAR: {
                return "C";
            }
            case DOUBLE: {
                return "D";
            }
            case FLOAT: {
                return "F";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case SHORT: {
                return "S";
            }
        }
        return null;
    }

    private static int arrayDepth(ArrayType type, int depth, Object[] typeOfArray) {
        if (type.getComponentType() instanceof ArrayType) {
            return TypeMirrorUtil.arrayDepth((ArrayType)type.getComponentType(), ++depth, typeOfArray);
        }
        typeOfArray[0] = type.getComponentType();
        return ++depth;
    }
}

