/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.model;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.security.SecurityIdentity;
import javax.jws.security.SecurityRoles;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandler;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.beehive.wsm.jsr181.model.AnnotationModel;
import org.apache.beehive.wsm.jsr181.model.SOAPBindingInfo;
import org.apache.beehive.wsm.jsr181.model.SOAPMessageHandlerInfo;
import org.apache.beehive.wsm.jsr181.model.SecurityRolesInfo;
import org.apache.beehive.wsm.jsr181.model.ValidationException;
import org.apache.beehive.wsm.jsr181.model.WebServiceMETHODMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServicePARAMETERMetadata;
import org.apache.beehive.wsm.jsr181.wsdl.WSDLProcessor;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceTYPEMetadata
extends AnnotationModel {
    private String wsName;
    private String wsServiceName;
    private String wsWsdlLocation;
    private String wsTargetNamespace;
    private String wsEndpointInterface;
    private Collection<WebServiceMETHODMetadata> methods = new ArrayList<WebServiceMETHODMetadata>();
    private SOAPBindingInfo soapBinding;
    private String hcFileName;
    private String hcName;
    private List<SOAPMessageHandlerInfo> soapHandlers = new ArrayList<SOAPMessageHandlerInfo>();
    private SecurityRolesInfo securityRoles;
    private String siValue;
    private String sibClassName;
    private String seiClassName;

    public WebServiceTYPEMetadata(String sibClassName) {
        this.sibClassName = sibClassName;
    }

    public WebServiceTYPEMetadata(WebService sibWsAnnotation, String sibClassName, Collection<Annotation> annotations, Collection<? extends WebServiceMETHODMetadata> webMethods) throws Exception {
        if (null == sibWsAnnotation) {
            throw new IllegalArgumentException("@WebService is required for service implementation beans");
        }
        if (null == sibClassName || 0 == sibClassName.length()) {
            throw new IllegalArgumentException("service implementation bean class not set");
        }
        this.sibClassName = sibClassName;
        if (null == annotations || null == webMethods) {
            throw new IllegalArgumentException("annotations or webMethods is null");
        }
        this.seiClassName = sibWsAnnotation.endpointInterface();
        if (AnnotationModel.hasAnnotationType(annotations, SOAPMessageHandlers.class) && AnnotationModel.hasAnnotationType(annotations, HandlerChain.class)) {
            throw new Exception("Illegal combination of @SOAPMessageHandlers and @HandlerChain");
        }
        WebService seiWsAnnotation = null;
        if (0 < this.seiClassName.length()) {
            seiWsAnnotation = (WebService)AnnotationModel.getAnnotationOfType(annotations, WebService.class);
        }
        this.initFromAnnotation(sibWsAnnotation, seiWsAnnotation);
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == HandlerChain.class) {
                this.initFromAnnotation((HandlerChain)annotation);
                continue;
            }
            if (annotation.annotationType() == SecurityIdentity.class) {
                this.initFromAnnotation((SecurityIdentity)annotation);
                continue;
            }
            if (annotation.annotationType() == SecurityRoles.class) {
                this.initFromAnnotation((SecurityRoles)annotation);
                continue;
            }
            if (annotation.annotationType() == SOAPBinding.class) {
                this.initFromAnnotation((SOAPBinding)annotation);
                continue;
            }
            if (annotation.annotationType() != SOAPMessageHandlers.class) continue;
            this.initFromAnnotation((SOAPMessageHandlers)annotation);
        }
        for (WebServiceMETHODMetadata webServiceMETHODMetadata : webMethods) {
            String wrTargetNamespace = webServiceMETHODMetadata.getWrTargetNamespace();
            if (null == wrTargetNamespace || 0 == wrTargetNamespace.length()) {
                webServiceMETHODMetadata.setWrTargetNamespace(this.getWsTargetNamespace());
            }
            for (WebServicePARAMETERMetadata wspm : webServiceMETHODMetadata.getParams()) {
                String wpTargetNamespace = wspm.getWpTargetNamespace();
                if (null != wpTargetNamespace && 0 != wpTargetNamespace.length()) continue;
                wspm.setWpTargetNamespace(this.getWsTargetNamespace());
            }
            this.addMethod(webServiceMETHODMetadata);
        }
    }

    protected void initFromAnnotation(WebService sibWsAnnotation, WebService seiWsAnnotation) {
        String serviceName;
        String name;
        if (null == seiWsAnnotation) {
            this.setWsName(sibWsAnnotation.name());
            this.setWsTargetNamespace(sibWsAnnotation.targetNamespace());
            this.setWsWsdlLocation(sibWsAnnotation.wsdlLocation());
        } else {
            this.setWsName(seiWsAnnotation.name());
            this.setWsTargetNamespace(seiWsAnnotation.targetNamespace());
            this.setWsWsdlLocation(seiWsAnnotation.wsdlLocation());
        }
        this.setWsServiceName(sibWsAnnotation.serviceName());
        this.setWsEndpointInterface(sibWsAnnotation.endpointInterface());
        String string = name = 0 == this.seiClassName.length() ? this.sibClassName : this.seiClassName;
        if (-1 < name.indexOf(46)) {
            int index = name.lastIndexOf(46);
            name = name.substring(index + 1);
        }
        if (0 == this.getWsName().length()) {
            this.setWsName(name);
        }
        if (-1 < (serviceName = this.sibClassName).indexOf(46)) {
            int index = serviceName.lastIndexOf(46);
            serviceName = serviceName.substring(index + 1);
        }
        if (0 == this.getWsServiceName().length()) {
            this.setWsServiceName(serviceName + "Service");
        }
        if (0 == this.getWsTargetNamespace().length()) {
            String defaultNamespaceSrc = 0 == this.seiClassName.length() ? this.sibClassName : this.seiClassName;
            this.setWsTargetNamespace(this.getTargetNamespace(defaultNamespaceSrc));
        }
    }

    private void initFromAnnotation(SOAPBinding annotation) {
        SOAPBindingInfo sbi;
        if (null != annotation) {
            this.setSoapBinding(new SOAPBindingInfo(annotation));
        }
        if (null == (sbi = this.getSoapBinding())) {
            throw new IllegalArgumentException("illegal SOAPBinding annotation on WebService class:\n\t" + sbi);
        }
    }

    private void initFromAnnotation(HandlerChain annotation) {
        if (null != annotation) {
            if (this.getSoapHandlers().isEmpty()) {
                String hcPath = annotation.file();
                String hcName = annotation.name();
                this.setHcFileName(hcPath);
                this.setHcName(hcName);
                try {
                    this.configureHandlerChain(hcPath, hcName);
                }
                catch (Exception e) {
                    throw new RuntimeException("An Exception occurred while configuring the HandlerChain", e);
                }
            } else {
                throw new IllegalArgumentException("SOAPMessageHandlers and HandlerChain annotations are mutually exclusive, and a SOAPMessageHandlers annotation is already present.");
            }
        }
    }

    private void initFromAnnotation(SOAPMessageHandlers annotation) {
        if (null != annotation) {
            if (null == this.getHcFileName()) {
                SOAPMessageHandler[] soapMsgHandlerArray = annotation.value();
                for (int i = 0; i < soapMsgHandlerArray.length; ++i) {
                    this.addSOAPHandler(new SOAPMessageHandlerInfo(soapMsgHandlerArray[i]));
                }
            } else {
                throw new IllegalArgumentException("SOAPMessageHandlers and HandlerChain annotations are mutually exclusive, and a HandlerChain annotation is already present.");
            }
        }
    }

    private void initFromAnnotation(SecurityRoles annotation) {
        if (null != annotation) {
            this.setSecurityRoles(new SecurityRolesInfo(annotation));
        }
    }

    private void initFromAnnotation(SecurityIdentity annotation) {
        if (null != annotation) {
            this.setSiValue(annotation.value());
        }
    }

    private void configureHandlerChain(String handlerChainConfigPath, String handlerChainName) throws Exception {
        URL handlerChainConfigURL;
        if (handlerChainConfigPath.indexOf("://") > 2) {
            handlerChainConfigURL = new URL(handlerChainConfigPath);
        } else {
            handlerChainConfigURL = this.getClass().getClassLoader().getResource(handlerChainConfigPath);
            if (handlerChainConfigURL == null) {
                StringBuffer fullPath = new StringBuffer(this.sibClassName.substring(0, this.sibClassName.lastIndexOf(46)));
                if (!handlerChainConfigPath.startsWith("/")) {
                    fullPath.append('/');
                }
                handlerChainConfigURL = this.getClass().getClassLoader().getResource(fullPath.toString().replace('.', '/') + handlerChainConfigPath);
            }
        }
        this.initHandlersFromChainConfig(handlerChainConfigURL, handlerChainName);
    }

    public void initHandlersFromChainConfig(URL chainConfigURL, String chainName) throws Exception {
        if (this.getSoapHandlers().isEmpty() && chainConfigURL != null && chainName != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(chainConfigURL.openStream());
            NodeList handlerChainNodes = doc.getElementsByTagName("handler-chain");
            for (int j = 0; j < handlerChainNodes.getLength(); ++j) {
                Element chainElement;
                NodeList chainNames;
                Node handlerChainNode = handlerChainNodes.item(j);
                if (handlerChainNode.getNodeType() != 1 || (chainNames = (chainElement = (Element)handlerChainNode).getElementsByTagName("handler-chain-name")).getLength() <= 0 || !chainName.equals(chainNames.item(0).getFirstChild().getNodeValue())) continue;
                NodeList handlers = chainElement.getElementsByTagName("handler");
                for (int k = 0; k < handlers.getLength(); ++k) {
                    this.processHandlerNode(handlers.item(k));
                }
            }
        }
    }

    private void processHandlerNode(Node handlerNode) {
        if (handlerNode.hasChildNodes()) {
            String handlerName = null;
            String handlerClassName = null;
            HashMap<String, String> initParams = new HashMap<String, String>();
            ArrayList<String> roles = new ArrayList<String>();
            ArrayList<String> headers = new ArrayList<String>();
            for (Node currentChild = handlerNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                String nodeName = currentChild.getNodeName();
                if ("handler-name".equals(nodeName)) {
                    handlerName = currentChild.getFirstChild().getNodeValue();
                    continue;
                }
                if ("handler-class".equals(nodeName)) {
                    handlerClassName = currentChild.getFirstChild().getNodeValue();
                    continue;
                }
                if ("soap-role".equals(nodeName)) {
                    roles.add(currentChild.getFirstChild().getNodeValue());
                    continue;
                }
                if ("soap-header".equals(nodeName)) {
                    headers.add(currentChild.getFirstChild().getNodeValue());
                    continue;
                }
                if (!"init-param".equals(nodeName)) continue;
                nodeName = currentChild.getFirstChild().getNodeName();
                if ("param-name".equals(nodeName)) {
                    initParams.put(currentChild.getFirstChild().getNodeValue(), currentChild.getLastChild().getNodeValue());
                    continue;
                }
                initParams.put(currentChild.getLastChild().getNodeValue(), currentChild.getFirstChild().getNodeValue());
            }
            this.addSOAPHandler(new SOAPMessageHandlerInfo(handlerClassName, handlerName, initParams, roles, headers));
        }
    }

    @Override
    public void validate() throws ValidationException {
        if (0 < this.seiClassName.length()) {
            try {
                Class<?> sibClass = Class.forName(this.sibClassName);
                Class<?> seiClass = Class.forName(this.seiClassName);
                for (Method m : seiClass.getMethods()) {
                    if (this.doesImplement(sibClass, m)) continue;
                    throw new ValidationException("The implementation bean doesn't implement " + m + " as required by the interface: " + this.getServiceImplementationBean());
                }
            }
            catch (ClassNotFoundException e) {
                throw new ValidationException("endpoint interface (" + this.seiClassName + ") or implementation bean (" + this.sibClassName + ") not on classpath");
            }
        }
        this.validateDuplicatedMethods();
    }

    private void validateDuplicatedMethods() throws ValidationException {
        WebServiceMETHODMetadata[] methods = this.getMethods().toArray(new WebServiceMETHODMetadata[0]);
        for (int i = 0; i < methods.length; ++i) {
            WebServiceMETHODMetadata method = methods[i];
            String methodName = method.getWmOperationName();
            for (int k = 0; k < methods.length; ++k) {
                WebServiceMETHODMetadata method_;
                if (i == k || !methodName.equals((method_ = methods[k]).getWmOperationName()) || !this.hasSameParameterTypes(method, method_)) continue;
                if (0 < this.seiClassName.length()) {
                    throw new ValidationException("There're duplicated operationName ( " + method.getWmOperationName() + " ) of methods, ( " + method.getJavaMethodName() + " )  and ( " + method_.getJavaMethodName() + " ) , in class ( " + this.seiClassName + " )");
                }
                throw new ValidationException("There're duplicated operationName ( " + method.getWmOperationName() + " ) of methods, ( " + method.getJavaMethodName() + " )  and ( " + method_.getJavaMethodName() + " ) , in class ( " + this.sibClassName + " )");
            }
        }
    }

    private boolean hasSameParameterTypes(WebServiceMETHODMetadata m1, WebServiceMETHODMetadata m2) {
        WebServicePARAMETERMetadata[] params2;
        WebServicePARAMETERMetadata[] params1 = m1.getParams().toArray(new WebServicePARAMETERMetadata[0]);
        if (params1.length != (params2 = m2.getParams().toArray(new WebServicePARAMETERMetadata[0])).length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i].getJavaType() == params2[i].getJavaType()) continue;
            return false;
        }
        return true;
    }

    private boolean doesImplement(Class sibClass, Method m) {
        if (null == m) {
            return false;
        }
        boolean found = false;
        for (Method _m : sibClass.getMethods()) {
            Class<?>[] _mTypes;
            Class<?>[] mTypes;
            if (!m.getName().equals(_m.getName()) || !m.getReturnType().equals(_m.getReturnType()) || (mTypes = m.getParameterTypes()).length != (_mTypes = _m.getParameterTypes()).length) continue;
            boolean isEqual = true;
            for (int i = 0; i < mTypes.length; ++i) {
                if (mTypes[i].equals(_mTypes[i])) continue;
                isEqual = false;
                break;
            }
            if (!isEqual) continue;
            found = true;
            break;
        }
        return found;
    }

    public DefinitionsDocument getWSDLAsDocument() throws IOException, XmlException {
        return WSDLProcessor.parseWSDL(this.getWsWsdlLocation());
    }

    public String getHcFileName() {
        return this.hcFileName;
    }

    public void setHcFileName(String hcFileName) {
        this.hcFileName = hcFileName;
    }

    public String getHcName() {
        return this.hcName;
    }

    public void setHcName(String hcName) {
        this.hcName = hcName;
    }

    public SecurityRolesInfo getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRolesInfo securityRoles) {
        this.securityRoles = securityRoles;
    }

    public String getSiValue() {
        return this.siValue;
    }

    public void setSiValue(String siValue) {
        this.siValue = siValue;
    }

    public SOAPBindingInfo getSoapBinding() {
        return this.soapBinding;
    }

    public void setSoapBinding(SOAPBindingInfo soapBinding) {
        this.soapBinding = soapBinding;
    }

    public String getWsName() {
        return this.wsName;
    }

    public void setWsName(String wsName) {
        this.wsName = wsName;
    }

    public String getWsServiceName() {
        return this.wsServiceName;
    }

    public void setWsServiceName(String wsServiceName) {
        this.wsServiceName = wsServiceName;
    }

    public String getWsTargetNamespace() {
        return this.wsTargetNamespace;
    }

    public void setWsTargetNamespace(String wsTargetNamespace) {
        this.wsTargetNamespace = wsTargetNamespace;
    }

    public String getWsEndpointInterface() {
        return this.wsEndpointInterface;
    }

    public void setWsEndpointInterface(String wsEndpointInterface) {
        this.wsEndpointInterface = wsEndpointInterface;
    }

    public String getWsWsdlLocation() {
        return this.wsWsdlLocation;
    }

    public void setWsWsdlLocation(String wsWsdlLocation) {
        this.wsWsdlLocation = wsWsdlLocation;
    }

    public Collection<WebServiceMETHODMetadata> getMethods() {
        return Collections.unmodifiableCollection(this.methods);
    }

    public void addMethod(WebServiceMETHODMetadata method) {
        this.methods.add(method);
    }

    public List<SOAPMessageHandlerInfo> getSoapHandlers() {
        return Collections.unmodifiableList(this.soapHandlers);
    }

    public void addSOAPHandler(SOAPMessageHandlerInfo soapHandler) {
        this.soapHandlers.add(soapHandler);
    }

    public String getServiceImplementationBean() {
        return this.sibClassName;
    }

    public String getServiceEndpointInterface() {
        return this.seiClassName;
    }

    private String getTargetNamespace(String fqClassName) {
        if (null == fqClassName || 0 == fqClassName.length()) {
            return fqClassName;
        }
        String[] tokens = fqClassName.split("\\.");
        String targetNamespace = tokens[0];
        for (int i = 1; i <= tokens.length - 2; ++i) {
            targetNamespace = tokens[i] + "." + targetNamespace;
        }
        return "http://" + targetNamespace;
    }
}

