/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.model;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.security.SecurityRoles;
import org.apache.beehive.wsm.jsr181.model.AnnotationModel;
import org.apache.beehive.wsm.jsr181.model.SecurityRolesInfo;
import org.apache.beehive.wsm.jsr181.model.ValidationException;
import org.apache.beehive.wsm.jsr181.model.WebServicePARAMETERMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceMETHODMetadata
extends AnnotationModel {
    private String wmOperationName;
    private String wmAction;
    private boolean oneway = false;
    private List<WebServicePARAMETERMetadata> params = new ArrayList<WebServicePARAMETERMetadata>();
    private String wrName;
    private String wrTargetNamespace;
    private SecurityRolesInfo securityRoles;
    private String javaMethodName;
    private Class javaReturnType;

    @Override
    public void validate() throws ValidationException {
    }

    public WebServiceMETHODMetadata(String methodName, Class returnType) {
        this.javaMethodName = methodName;
        this.javaReturnType = returnType;
    }

    public WebServiceMETHODMetadata(String javaMethodName, Class javaReturnType, boolean throwsExceptions, Collection<Annotation> annotations, List<? extends WebServicePARAMETERMetadata> webParams) throws Exception {
        if (null == javaMethodName || null == javaReturnType) {
            throw new IllegalArgumentException("javaMethodName or javaReturnType not set");
        }
        this.javaMethodName = javaMethodName;
        this.javaReturnType = javaReturnType;
        this.setWrName("result");
        if (AnnotationModel.hasAnnotationType(annotations, Oneway.class)) {
            if (AnnotationModel.hasAnnotationType(annotations, WebResult.class)) {
                throw new Exception("@Oneway method " + javaMethodName + " has incompatible annotation: @WebResult");
            }
            if (Void.TYPE != javaReturnType) {
                throw new Exception("@Oneway method " + javaMethodName + " has illegal non-void return type: " + javaReturnType);
            }
            if (throwsExceptions) {
                throw new Exception("@Oneway method " + javaMethodName + " must not throw exceptions");
            }
            if (null != webParams) {
                for (WebServicePARAMETERMetadata webServicePARAMETERMetadata : webParams) {
                    if (WebParam.Mode.OUT != webServicePARAMETERMetadata.getWpMode() && WebParam.Mode.INOUT != webServicePARAMETERMetadata.getWpMode()) continue;
                    throw new Exception("@Oneway method " + javaMethodName + " has illegal INOUT or OUT parameter: " + webServicePARAMETERMetadata.getWpName());
                }
            }
        }
        if (null != annotations) {
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() == WebMethod.class) {
                    this.initFromAnnotation((WebMethod)annotation);
                    continue;
                }
                if (annotation.annotationType() == Oneway.class) {
                    this.initFromAnnotation((Oneway)annotation);
                    continue;
                }
                if (annotation.annotationType() == SecurityRoles.class) {
                    this.initFromAnnotation((SecurityRoles)annotation);
                    continue;
                }
                if (annotation.annotationType() != WebResult.class) continue;
                this.initFromAnnotation((WebResult)annotation);
            }
        }
        if (null == this.getWmOperationName() || 0 == this.getWmOperationName().length()) {
            this.setWmOperationName(javaMethodName);
        }
        if (null == this.getWmAction() || 0 == this.getWmAction().length()) {
            this.setWmAction("");
        }
        this.addParams(webParams);
    }

    private void initFromAnnotation(SecurityRoles annotation) {
        if (null != annotation) {
            this.setSecurityRoles(new SecurityRolesInfo(annotation));
        }
    }

    private void initFromAnnotation(WebResult annotation) {
        if (null != annotation) {
            this.setWrName(annotation.name());
            this.setWrTargetNamespace(annotation.targetNamespace());
        }
    }

    private void initFromAnnotation(Oneway annotation) {
        this.setOneWay(null != annotation);
    }

    private void initFromAnnotation(WebMethod annotation) {
        if (null != annotation) {
            this.setWmAction(annotation.action());
            this.setWmOperationName(annotation.operationName());
        }
    }

    public boolean isOneWay() {
        return this.oneway;
    }

    public void setOneWay(boolean oneway) {
        this.oneway = oneway;
    }

    public SecurityRolesInfo getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRolesInfo securityRoles) {
        this.securityRoles = securityRoles;
    }

    public String getWmAction() {
        return this.wmAction;
    }

    public void setWmAction(String wmAction) {
        this.wmAction = wmAction;
    }

    public String getWmOperationName() {
        return this.wmOperationName;
    }

    public void setWmOperationName(String wmOperationName) {
        this.wmOperationName = wmOperationName;
    }

    public String getWrName() {
        return this.wrName;
    }

    public void setWrName(String wrName) {
        this.wrName = wrName;
    }

    public String getWrTargetNamespace() {
        return this.wrTargetNamespace;
    }

    public void setWrTargetNamespace(String wrTargetNamespace) {
        this.wrTargetNamespace = wrTargetNamespace;
    }

    public List<WebServicePARAMETERMetadata> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    public void addParams(Collection<? extends WebServicePARAMETERMetadata> parameters) {
        if (null != parameters) {
            this.params.addAll(parameters);
        }
    }

    public void addParam(WebServicePARAMETERMetadata parameter) {
        if (null != parameter) {
            this.params.add(parameter);
        }
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public Class getJavaReturnType() {
        return this.javaReturnType;
    }
}

