/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.jsr181.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jws.soap.InitParam;
import javax.jws.soap.SOAPMessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageHandlerInfo {
    String name;
    String className;
    HashMap<String, String> parameterMap = new HashMap();
    Collection<String> roles = new ArrayList<String>();
    Collection<String> headers = new ArrayList<String>();

    public SOAPMessageHandlerInfo(SOAPMessageHandler annotation) {
        String handlerClassName = annotation.className();
        if (handlerClassName.length() == 0) {
            throw new IllegalArgumentException("A className is required to configure a SOAPMessageHandler");
        }
        this.setClassName(handlerClassName);
        String handlerName = annotation.name();
        this.setName(handlerName.length() > 0 ? handlerName : handlerClassName);
        for (InitParam p : annotation.initParams()) {
            this.addInitParam(p.name(), p.value());
        }
        this.addRoles(Arrays.asList(annotation.roles()));
        for (String s : annotation.headers()) {
            this.addHeader(s);
        }
    }

    public SOAPMessageHandlerInfo(String handlerClassName, String handlerName, Map<String, String> initParams, Collection<String> roles, Collection<String> headers) {
        this.setClassName(handlerClassName);
        this.setName(handlerName != null && handlerName.length() > 0 ? handlerName : handlerClassName);
        this.addInitParams(initParams);
        this.addRoles(roles);
        this.addHeaders(headers);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<String> getHeaders() {
        return Collections.unmodifiableCollection(this.headers);
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    private void addHeaders(Collection<String> headers) {
        this.headers.addAll(headers);
    }

    public Map<String, String> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public void addInitParam(String key, String value) {
        this.parameterMap.put(key, value);
    }

    public void addInitParams(Map<String, String> params) {
        this.parameterMap.putAll(params);
    }

    public Collection<String> getRoles() {
        return Collections.unmodifiableCollection(this.roles);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addRoles(Collection<String> roles) {
        this.roles.addAll(roles);
    }
}

