/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.type;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.NetuiConfigDocument;
import org.apache.beehive.netui.util.config.bean.TypeConverters;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.beehive.netui.util.type.BaseTypeConverter;
import org.apache.beehive.netui.util.type.DelegatingTypeConverter;
import org.apache.beehive.netui.util.type.TypeConversionException;
import org.apache.beehive.netui.util.type.TypeConverter;
import org.apache.beehive.netui.util.type.TypeConverterNotFoundException;

public final class TypeUtils {
    private static final Logger logger = Logger.getInstance(TypeUtils.class);
    private static final String TYPE_CONVERTER_PROPERTIES = "/properties/netui-typeconverter.properties";
    private static final String EMPTY_STRING = "";
    private static final HashMap _converters = new HashMap();
    private static String _toString = null;

    private TypeUtils() {
    }

    public static final Object convertToObject(String value, Class type) {
        BaseTypeConverter converter = TypeUtils.lookupTypeConverter(type);
        assert (converter != null);
        return converter.convertToObject(value);
    }

    public static final Object convertToObject(String value, Class type, Locale locale) {
        BaseTypeConverter converter = TypeUtils.lookupTypeConverter(type);
        assert (converter != null);
        return converter.convertToObject(value, locale);
    }

    public static final byte convertToByte(String value) {
        return (Byte)TypeUtils.convertToObject(value, Byte.TYPE);
    }

    public static final boolean convertToBoolean(String value) {
        return (Boolean)TypeUtils.convertToObject(value, Boolean.TYPE);
    }

    public static final char convertToChar(String value) {
        return ((Character)TypeUtils.convertToObject(value, Character.TYPE)).charValue();
    }

    public static final double convertToDouble(String value) {
        return (Double)TypeUtils.convertToObject(value, Double.TYPE);
    }

    public static final float convertToFloat(String value) {
        return ((Float)TypeUtils.convertToObject(value, Float.TYPE)).floatValue();
    }

    public static final int convertToInt(String value) {
        return (Integer)TypeUtils.convertToObject(value, Integer.TYPE);
    }

    public static final long convertToLong(String value) {
        return (Long)TypeUtils.convertToObject(value, Long.TYPE);
    }

    public static final short convertToShort(String value) {
        return (Short)TypeUtils.convertToObject(value, Short.TYPE);
    }

    public static final Byte convertToByteObject(String value) {
        return (Byte)TypeUtils.convertToObject(value, Byte.class);
    }

    public static final Boolean convertToBooleanObject(String value) {
        return (Boolean)TypeUtils.convertToObject(value, Boolean.class);
    }

    public static final Character convertToCharacterObject(String value) {
        return (Character)TypeUtils.convertToObject(value, Character.class);
    }

    public static final Double convertToDoubleObject(String value) {
        return (Double)TypeUtils.convertToObject(value, Double.class);
    }

    public static final Float convertToFloatObject(String value) {
        return (Float)TypeUtils.convertToObject(value, Float.class);
    }

    public static final Integer convertToIntegerObject(String value) {
        return (Integer)TypeUtils.convertToObject(value, Integer.class);
    }

    public static final Long convertToLongObject(String value) {
        return (Long)TypeUtils.convertToObject(value, Long.class);
    }

    public static final Short convertToShortObject(String value) {
        return (Short)TypeUtils.convertToObject(value, Short.class);
    }

    private static final BaseTypeConverter lookupTypeConverter(Class type) {
        BaseTypeConverter converter = (BaseTypeConverter)_converters.get(type);
        if (converter == null) {
            String msg = "Could not find a TypeConverter for converting a String to an object of type \"" + (type != null ? type.getName() : null) + "\"";
            TypeConverterNotFoundException tcn = new TypeConverterNotFoundException(msg);
            msg = type == null ? Bundle.getErrorString("TypeUtils_nullType") : Bundle.getErrorString("TypeUtils_noConverterForType", new Object[]{type.getName()});
            tcn.setLocalizedMessage(msg);
            if (logger.isInfoEnabled()) {
                logger.info(msg);
            }
            throw tcn;
        }
        return converter;
    }

    private static String registeredConvertersToString() {
        if (_toString != null) {
            return _toString;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(TypeUtils.class.getName() + " regestered converters (class name, TypeConverter implementation):\n");
        buf.append(":::::\n");
        for (Class key : _converters.keySet()) {
            String keyName = key.getName();
            String value = _converters.get(key) != null ? _converters.get(key).getClass().getName() : "null";
            buf.append(keyName);
            buf.append(", ");
            buf.append(value);
            buf.append("\n");
        }
        buf.append(":::::\n");
        _toString = buf.toString();
        return _toString;
    }

    private static void loadConverters() {
        Map map = TypeUtils.readFromConfig();
        if (map != null) {
            TypeUtils.load(map);
            map.clear();
        }
        if ((map = TypeUtils.readFromProperties()) != null) {
            TypeUtils.load(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readFromProperties() {
        Properties props = null;
        InputStream is = null;
        try {
            is = TypeUtils.class.getClassLoader().getResourceAsStream(TYPE_CONVERTER_PROPERTIES);
            if (logger.isDebugEnabled()) {
                logger.debug("InputStream: " + is);
            }
            if (is == null) {
                Map map = null;
                return map;
            }
            props = new Properties();
            props.load(is);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error occurred reading type converter properties file", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, props.getProperty(key));
        }
        return map;
    }

    private static final Map readFromConfig() {
        NetuiConfigDocument.NetuiConfig config = ConfigUtil.getConfig();
        if (config == null) {
            return null;
        }
        TypeConverters converters = config.getTypeConverters();
        if (converters == null) {
            return null;
        }
        TypeConverters.TypeConverter[] converterArray = converters.getTypeConverterArray();
        if (converterArray == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < converterArray.length; ++i) {
            map.put(converterArray[i].getType(), converterArray[i].getConverterClass());
        }
        return map;
    }

    private static void load(Map map) {
        for (String key : map.keySet()) {
            TypeConverter tc;
            Class<?> targetClazz;
            String className;
            block9: {
                className = (String)map.get(key);
                if (key == null || key.equals(EMPTY_STRING) || className == null || className.equals(EMPTY_STRING)) {
                    String msg = "Could not create a TypeConverter for type \"" + key + "\" and TypeConverter \"" + className + "\"";
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(msg);
                    continue;
                }
                targetClazz = null;
                Class<?> tcClazz = null;
                tc = null;
                try {
                    targetClazz = Class.forName(key);
                }
                catch (ClassNotFoundException cnf) {
                    String msg = "Could not create a TypeConverter for type \"" + key + "\" because the target type could not be found.";
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(msg);
                    continue;
                }
                try {
                    tcClazz = Class.forName(className);
                    tc = (TypeConverter)tcClazz.newInstance();
                    if (tc instanceof BaseTypeConverter) break block9;
                    tc = new DelegatingTypeConverter(tc);
                }
                catch (ClassNotFoundException cnf) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Could not create a TypeConverter for type \"" + key + "\" because the TypeConverter implementation class \"" + (tcClazz != null ? tcClazz.getName() : null) + "\" could not be found.");
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Could not create a TypeConverter for type \"" + key + "\" because the implementation class \"" + (tcClazz != null ? tcClazz.getName() : null) + "\" could not be instantiated.");
                    continue;
                }
            }
            if (_converters.containsKey(targetClazz) && logger.isWarnEnabled()) {
                logger.warn("Overwriting a previously defined TypeConverter named \"" + targetClazz + "\" with a new TypeConverter implementation of type \"" + className + "\"");
            }
            if (logger.isInfoEnabled()) {
                logger.info("Adding a type converter; target type=\"" + targetClazz.getName() + "\" TypeConverter implementation=\"" + tc.getClass().getName() + "\"");
            }
            _converters.put(targetClazz, tc);
        }
    }

    private static void initialize() {
        _converters.put(Byte.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                return value == null || value.equals(TypeUtils.EMPTY_STRING) ? new Byte(0) : new Byte(value.trim());
            }
        });
        _converters.put(Byte.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Byte.TYPE);
            }
        });
        _converters.put(Boolean.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return Boolean.FALSE;
                }
                if ((value = value.toLowerCase().trim()).equals("on") || value.equals("true")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        _converters.put(Boolean.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Boolean.TYPE);
            }
        });
        _converters.put(Character.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Character('\u0000');
                }
                return new Character(value.charAt(0));
            }
        });
        _converters.put(Character.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Character.TYPE);
            }
        });
        _converters.put(Double.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Double(0.0);
                }
                return new Double(value.trim());
            }
        });
        _converters.put(Double.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Double.TYPE);
            }
        });
        _converters.put(Float.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Float(0.0);
                }
                return new Float(value.trim());
            }
        });
        _converters.put(Float.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Float.TYPE);
            }
        });
        _converters.put(Integer.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Integer(0);
                }
                return new Integer(value.trim());
            }
        });
        _converters.put(Integer.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Integer.TYPE);
            }
        });
        _converters.put(Long.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Long(0L);
                }
                return new Long(value.trim());
            }
        });
        _converters.put(Long.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Long.TYPE);
            }
        });
        _converters.put(Short.TYPE, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return new Short(0);
                }
                return new Short(value.trim());
            }
        });
        _converters.put(Short.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return TypeUtils.convertToObject(value, Short.TYPE);
            }
        });
        _converters.put(String.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null) {
                    return null;
                }
                return value;
            }
        });
        _converters.put(BigDecimal.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return new BigDecimal(value.trim());
            }
        });
        _converters.put(BigInteger.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return new BigInteger(value.trim());
            }
        });
        _converters.put(byte[].class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                return value.getBytes();
            }
        });
        _converters.put(Byte[].class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                TypeConverter primByte = (TypeConverter)_converters.get(Byte.TYPE);
                byte[] bytes = value.getBytes();
                Byte[] wBytes = new Byte[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    wBytes[i] = new Byte(bytes[i]);
                }
                return wBytes;
            }
        });
        _converters.put(java.util.Date.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    if (locale == null) {
                        locale = Locale.getDefault();
                    }
                    DateFormat df = DateFormat.getDateInstance(3, locale);
                    return df.parse(value);
                }
                catch (ParseException pe) {
                    String msg = "Caugnt an error converting a String to a DateFormat.SHORT formatted Date";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, pe);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, pe);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaUtilDateConvertError", new Object[]{pe.getMessage()}));
                    throw tce;
                }
            }
        });
        _converters.put(Date.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    return Date.valueOf(value);
                }
                catch (Exception e) {
                    String msg = "Caught an error converting a String to a java.sql.Date";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, e);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, e);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaSqlDateConvertError", new Object[]{e.getMessage()}));
                    throw tce;
                }
            }
        });
        _converters.put(Timestamp.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    return Timestamp.valueOf(value);
                }
                catch (Exception e) {
                    String msg = "Caught an error converting a String to a java.sql.Timestamp";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, e);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, e);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaSqlTimestampConvertError", new Object[]{e.getMessage()}));
                    throw tce;
                }
            }
        });
        _converters.put(Time.class, new BaseTypeConverter(){

            public Object convertToObject(String value, Locale locale) {
                if (value == null || value.equals(TypeUtils.EMPTY_STRING)) {
                    return null;
                }
                try {
                    return Time.valueOf(value);
                }
                catch (Exception e) {
                    String msg = "Caught an error converting a String to a java.sql.Time";
                    if (logger.isWarnEnabled()) {
                        logger.warn(msg, e);
                    }
                    System.err.println(msg);
                    TypeConversionException tce = new TypeConversionException(msg, e);
                    tce.setLocalizedMessage(Bundle.getString("TypeUtils_javaSqlTimeConvertError", new Object[]{e.getMessage()}));
                    throw tce;
                }
            }
        });
    }

    static {
        TypeUtils.initialize();
        TypeUtils.loadConverters();
        if (logger.isInfoEnabled()) {
            logger.info(TypeUtils.registeredConvertersToString());
        }
    }
}

