/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.iterator;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.IteratorFactories;
import org.apache.beehive.netui.util.config.bean.NetuiConfigDocument;
import org.apache.beehive.netui.util.iterator.ArrayIterator;
import org.apache.beehive.netui.util.iterator.AtomicObjectIterator;
import org.apache.beehive.netui.util.iterator.EmptyIterator;
import org.apache.beehive.netui.util.iterator.EnumerationIterator;
import org.apache.beehive.netui.util.iterator.IteratorFactoryException;
import org.apache.beehive.netui.util.iterator.MapIterator;
import org.apache.beehive.netui.util.iterator.ResultSetIterator;
import org.apache.beehive.netui.util.logging.Logger;

public class IteratorFactory {
    private static final Logger _logger = Logger.getInstance(IteratorFactory.class);
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private static final Map _plantMap = new LinkedHashMap();

    public static Iterator makeIterator(Object object) throws IteratorFactoryException {
        try {
            return IteratorFactory.createIterator(object);
        }
        catch (Exception e) {
            Class<?> objectType = object != null ? object.getClass() : null;
            String message = "An error occurred creating an iterator for type \"" + objectType + "\"";
            throw new IteratorFactoryException(message, e, objectType);
        }
    }

    public static final Iterator createIterator(Object object) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Trying to make an iterator for class: " + (object == null ? "null" : object.getClass().getName()));
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.iterator();
        }
        if (object instanceof Map) {
            return new MapIterator((Map)object);
        }
        if (object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        if (object instanceof ResultSet && !(object instanceof RowSet)) {
            return new ResultSetIterator((ResultSet)object);
        }
        Iterator ret = null;
        Iterator factories = _plantMap.keySet().iterator();
        while (factories.hasNext()) {
            IteratorPlant plant = (IteratorPlant)_plantMap.get(factories.next());
            ret = plant.createIterator(object);
            if (ret == null) continue;
            return ret;
        }
        return new AtomicObjectIterator(object);
    }

    private static final void initialize() {
        Map map = IteratorFactory.readFromConfig();
        if (map != null) {
            IteratorFactory.loadFactories(map);
        }
    }

    private static final Map readFromConfig() {
        NetuiConfigDocument.NetuiConfig config = ConfigUtil.getConfig();
        if (config == null) {
            return null;
        }
        IteratorFactories factories = config.getIteratorFactories();
        if (factories == null) {
            return null;
        }
        IteratorFactories.IteratorFactory[] factoryArray = factories.getIteratorFactoryArray();
        if (factoryArray == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < factoryArray.length; ++i) {
            map.put(factoryArray[i].getName(), factoryArray[i].getFactoryClass());
        }
        return map;
    }

    private static final void loadFactories(Map factories) {
        for (String name : factories.keySet()) {
            String className = (String)factories.get(name);
            IteratorPlant plant = null;
            try {
                Class<?> type = Class.forName(className);
                plant = (IteratorPlant)type.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn("Could not create an IteratorPlant for type \"" + className + "\" because the implementation class could not be found.");
                continue;
            }
            catch (Exception e) {
                assert (e instanceof InstantiationException || e instanceof IllegalAccessException);
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn("Could not create an IteratorPlant for type \"" + className + "\" because an error occurred creating the plant.  Cause: " + e, e);
                continue;
            }
            if (_plantMap.containsKey(name)) {
                if (_logger.isWarnEnabled()) {
                    _logger.warn("Overwriting a previously defined IteratorPlant named \"" + name + "\" with a new IteratorPlant of type \"" + className + "\"");
                }
            } else if (_logger.isInfoEnabled()) {
                _logger.info("Adding an IteratorPlant named \"" + name + "\" with implementation \"" + className + "\"");
            }
            _plantMap.put(name, plant);
        }
    }

    static {
        IteratorFactory.initialize();
    }

    public static abstract class IteratorPlant {
        public abstract Iterator createIterator(Object var1);
    }
}

