/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.beehive.netui.util.config.ConfigInitializationException;
import org.apache.beehive.netui.util.config.bean.NetuiConfigDocument;
import org.apache.beehive.netui.util.logging.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public final class ConfigUtil {
    private static final Logger _logger = Logger.getInstance(ConfigUtil.class);
    private static final String DEFAULT_CONFIG = "org/apache/beehive/netui/util/config/netui-config-default.xml";
    private static NetuiConfigDocument _config = null;

    public static final void init(InputStream is) throws ConfigInitializationException {
        if (is == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            is = cl.getResourceAsStream(DEFAULT_CONFIG);
            if (is == null) {
                throw new ConfigInitializationException("The NetUI runtime could not find the default config file.  The webapp may not function properly.");
            }
            if (_logger.isInfoEnabled()) {
                _logger.info("Loading the default NetUI config file.  The runtime will be configured with a set of minimum parameters.");
            }
        }
        if (_config == null) {
            try {
                XmlOptions loadOptions = new XmlOptions();
                loadOptions.setLoadLineNumbers();
                _config = NetuiConfigDocument.Factory.parse(is, loadOptions);
            }
            catch (Exception ex) {
                assert (ex instanceof XmlException || ex instanceof IOException);
                throw new ConfigInitializationException("Unable load the NetUI config file.  Cause: " + ex, ex);
            }
        } else {
            throw new ConfigInitializationException("Config initialization already completed; unable to reload the NetUI config file.");
        }
        assert (_config != null);
        XmlOptions validateOptions = new XmlOptions();
        ArrayList errorList = new ArrayList();
        validateOptions.setErrorListener(errorList);
        boolean isValid = _config.validate(validateOptions);
        if (!isValid) {
            StringBuilder msg = new StringBuilder("Invalid NetUI configuration file.");
            for (int i = 0; i < errorList.size(); ++i) {
                XmlError error = (XmlError)errorList.get(i);
                msg.append("\n    line ");
                msg.append(error.getLine());
                msg.append(": ");
                msg.append(error.getMessage());
                msg.append(" (");
                msg.append(error.getCursorLocation().toString());
                msg.append(")");
            }
            throw new ConfigInitializationException(msg.toString());
        }
    }

    public static NetuiConfigDocument.NetuiConfig getConfig() {
        if (_config != null) {
            return _config.getNetuiConfig();
        }
        if (_logger.isErrorEnabled()) {
            _logger.error("An error occurred parsing the default config file.  The NetUI runtime is not properly configured.");
        }
        throw new IllegalStateException("The NetUI runtime could not find the default config file.  The webapp may not function properly.");
    }
}

