/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.cache;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beehive.netui.util.logging.Logger;

public class PropertyCache {
    private static final Logger _logger = Logger.getInstance(PropertyCache.class);
    private final ConcurrentHashMap _classCache = new ConcurrentHashMap();

    public final PropertyDescriptor[] getPropertyDescriptors(Class type) {
        CachedClass cc = this.getCachedClass(type);
        return cc != null ? cc.getPropertyDescriptors() : null;
    }

    public final Method getPropertyGetter(Class type, String property) {
        CachedClass cc = this.getCachedClass(type);
        if (cc == null) {
            return null;
        }
        CachedProperty cp = cc.getProperty(property);
        return cp != null ? cp.getReadMethod() : null;
    }

    public final Method getPropertySetter(Class type, String property) {
        CachedClass cc = this.getCachedClass(type);
        if (cc == null) {
            return null;
        }
        CachedProperty cp = cc.getProperty(property);
        return cp != null ? cp.getWriteMethod() : null;
    }

    public final Class getPropertyType(Class type, String property) {
        CachedClass cc = this.getCachedClass(type);
        if (cc == null) {
            return null;
        }
        CachedProperty cp = cc.getProperty(property);
        return cp != null ? cp.getType() : null;
    }

    public final Field getField(Class type, String field) {
        CachedClass cc = this.getCachedClass(type);
        return cc != null ? cc.getField(field) : null;
    }

    private final CachedClass getCachedClass(Class type) {
        Object obj = this._classCache.get(type);
        if (obj == null) {
            try {
                obj = new CachedClass(type);
                this._classCache.put(type, obj);
            }
            catch (Exception e) {
                if (_logger.isErrorEnabled()) {
                    _logger.error("Error introspecting a class of type \"" + type + "\" when determining its JavaBean property info", e);
                }
                return null;
            }
        }
        return (CachedClass)obj;
    }

    private class CachedField {
        private Field field = null;
        private String name = null;

        CachedField(Field field) {
            this.name = field.getName();
            this.field = field;
        }

        Field getField() {
            return this.field;
        }

        String getName() {
            return this.name;
        }
    }

    private class CachedProperty {
        private Method readMethod = null;
        private Method writeMethod = null;
        private String name = null;
        private PropertyDescriptor pd = null;
        private Class type = null;

        CachedProperty(PropertyDescriptor pd) {
            this.pd = pd;
            this.name = pd.getName();
            this.readMethod = pd.getReadMethod();
            this.writeMethod = pd.getWriteMethod();
            this.type = pd.getPropertyType();
        }

        PropertyDescriptor getPropertyDescriptor() {
            return this.pd;
        }

        Method getReadMethod() {
            return this.readMethod;
        }

        Method getWriteMethod() {
            return this.writeMethod;
        }

        String getName() {
            return this.name;
        }

        Class getType() {
            return this.type;
        }
    }

    private class CachedClass {
        private Class type = null;
        private HashMap props = null;
        private HashMap fields = null;
        private PropertyDescriptor[] pds = null;

        CachedClass(Class type) throws IntrospectionException {
            this.type = type;
            this.init(type);
        }

        private void init(Class type) throws IntrospectionException {
            this.props = new HashMap();
            if (Modifier.isPublic(type.getModifiers())) {
                PropertyDescriptor[] pds = Introspector.getBeanInfo(type).getPropertyDescriptors();
                for (int i = 0; i < pds.length; ++i) {
                    this.props.put(pds[i].getName(), new CachedProperty(pds[i]));
                }
                this.fields = new HashMap();
                Field[] fs = type.getFields();
                for (int i = 0; i < fs.length; ++i) {
                    if (!Modifier.isPublic(fs[i].getModifiers()) || Modifier.isStatic(fs[i].getModifiers())) continue;
                    this.fields.put(fs[i].getName(), new CachedField(fs[i]));
                }
            } else {
                for (Class c = type; c != null; c = c.getSuperclass()) {
                    Class<?>[] interfaces = c.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        Class<?> iface = interfaces[i];
                        if (!Modifier.isPublic(iface.getModifiers())) continue;
                        PropertyDescriptor[] pds = Introspector.getBeanInfo(iface).getPropertyDescriptors();
                        for (int j = 0; j < pds.length; ++j) {
                            if (this.props.containsKey(pds[j].getName())) continue;
                            this.props.put(pds[j].getName(), new CachedProperty(pds[j]));
                        }
                    }
                }
                Class baseClass = type.getSuperclass();
                while (!Modifier.isPublic(baseClass.getModifiers())) {
                    baseClass = baseClass.getSuperclass();
                }
                PropertyDescriptor[] pds = Introspector.getBeanInfo(baseClass).getPropertyDescriptors();
                for (int j = 0; j < pds.length; ++j) {
                    if (this.props.containsKey(pds[j].getName())) continue;
                    this.props.put(pds[j].getName(), new CachedProperty(pds[j]));
                }
                this.fields = new HashMap();
                Field[] fs = baseClass.getFields();
                for (int i = 0; i < fs.length; ++i) {
                    if (!Modifier.isPublic(fs[i].getModifiers()) || Modifier.isStatic(fs[i].getModifiers())) continue;
                    this.fields.put(fs[i].getName(), new CachedField(fs[i]));
                }
            }
            if (this.props.size() > 0) {
                this.pds = new PropertyDescriptor[this.props.size()];
                Iterator iterator = this.props.values().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    this.pds[i] = ((CachedProperty)iterator.next()).getPropertyDescriptor();
                    ++i;
                }
            }
        }

        PropertyDescriptor[] getPropertyDescriptors() {
            return this.pds;
        }

        Field getField(String name) {
            CachedField cf = (CachedField)this.fields.get(name);
            return cf != null ? cf.getField() : null;
        }

        CachedProperty getProperty(String name) {
            return (CachedProperty)this.props.get(name);
        }
    }
}

