/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.cache;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beehive.netui.util.logging.Logger;

public class MethodCache {
    private static final Logger _logger = Logger.getInstance(MethodCache.class);
    private final ConcurrentHashMap _methodCache = new ConcurrentHashMap();

    public final Method[] getMethods(Class type) {
        Object obj;
        if (_logger.isDebugEnabled()) {
            _logger.debug("type: " + type + " hash code: " + type.hashCode());
        }
        if ((obj = this._methodCache.get(type)) == null) {
            obj = type.getMethods();
            this._methodCache.put(type, obj);
        }
        return (Method[])obj;
    }

    public final Method getMethod(Class type, String methodName, int argCount) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Get method \"" + methodName + "\" from type \"" + type + "\" with " + argCount + " params");
        }
        if (methodName == null) {
            return null;
        }
        Method[] methods = this.getMethods(type);
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || argCount != methods[i].getParameterTypes().length) continue;
            return methods[i];
        }
        return null;
    }

    public final Method getMethod(Class type, String methodName, String[] argTypes) {
        if (methodName == null) {
            return null;
        }
        Method[] methods = this.getMethods(type);
        Class<?>[] parameterTypes = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            parameterTypes = methods[i].getParameterTypes();
            if ((argTypes == null || argTypes.length == 0) && parameterTypes.length == 0) {
                return methods[i];
            }
            if ((argTypes == null || argTypes.length == 0) && parameterTypes.length != 0 || parameterTypes == null || parameterTypes.length != argTypes.length) continue;
            boolean match = true;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (parameterTypes[j].getName().equals(argTypes[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return methods[i];
        }
        return null;
    }

    public final Method getMethod(Class type, String methodName, Class[] argTypes) {
        if (argTypes == null) {
            return this.getMethod(type, methodName, (String[])null);
        }
        String[] typeStrs = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            typeStrs[i] = argTypes[i].getName();
        }
        return this.getMethod(type, methodName, typeStrs);
    }
}

