/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.logging.Logger;

public class ParamHelper {
    private static final Logger logger = Logger.getInstance(ParamHelper.class);

    public static void addParam(Map params, String name, Object value) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter map cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (value instanceof Map) {
            logger.warn(Bundle.getString("Tags_BadParameterType", name));
            return;
        }
        if (value == null) {
            value = "";
        }
        Object o = params.get(name);
        int length = 0;
        if (o != null) {
            assert (o instanceof String || o instanceof String[]);
            length = o.getClass().isArray() ? Array.getLength(o) : ++length;
        }
        length = value.getClass().isArray() ? (length += Array.getLength(value)) : (value instanceof List ? (length += ((List)value).size()) : ++length);
        if (length == 0) {
            return;
        }
        if (length == 1) {
            if (value.getClass().isArray()) {
                Object val = Array.get(value, 0);
                if (val != null) {
                    params.put(name, val.toString());
                } else {
                    params.put(name, "");
                }
            } else if (value instanceof List) {
                List list = (List)value;
                Object val = list.get(0);
                if (val != null) {
                    params.put(name, val.toString());
                } else {
                    params.put(name, "");
                }
            } else {
                params.put(name, value.toString());
            }
            return;
        }
        String[] values = new String[length];
        if (o != null) {
            int offset;
            if (o.getClass().isArray()) {
                String[] obs = (String[])o;
                for (offset = 0; offset < obs.length; ++offset) {
                    values[offset] = obs[offset];
                }
            } else {
                values[0] = o.toString();
                offset = 1;
            }
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            for (int i = 0; i < size; ++i) {
                Object val = Array.get(value, i);
                values[i + offset] = val != null ? val.toString() : "";
            }
        } else if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                values[i + offset] = list.get(i) != null ? list.get(i).toString() : "";
            }
        } else {
            values[offset] = value.toString();
        }
        params.put(name, values);
    }
}

