/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class HtmlExceptionFormatter {
    private static final String HTML_LINE_BREAK = "<br/>";
    private static final String LINE_BREAK = "\n";
    private static final String CAUSED_BY = "caused by: ";

    public static String format(String message, Throwable t, boolean stackTrace) {
        StringBuilder buf = new StringBuilder();
        if (message != null) {
            buf.append(message);
            if (t.getCause() != null) {
                buf.append(HTML_LINE_BREAK);
                buf.append(CAUSED_BY);
                buf.append(": ");
                buf.append(t.getCause().toString());
            }
        }
        if (stackTrace) {
            if (message != null) {
                buf.append(HTML_LINE_BREAK);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            pw.close();
            String error = sw.toString();
            int pos = error.indexOf(LINE_BREAK);
            if (pos != -1) {
                String lineOne = error.substring(0, pos);
                String rest = error.substring(pos);
                buf.append("<span class='pfErrorLineOne'>");
                buf.append(lineOne);
                buf.append("</span>");
                buf.append(rest);
            } else {
                buf.append(sw.toString());
            }
        }
        return buf.toString().replaceAll(LINE_BREAK, HTML_LINE_BREAK);
    }
}

