/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util;

import java.io.File;

public class FileUtils {
    private static final boolean OS_CASE_SENSITIVE = !new File("x").equals(new File("X"));

    public static boolean isAbsoluteURI(String uri) {
        if (uri.length() == 0 || uri.charAt(0) == '/') {
            return false;
        }
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (c != '/') continue;
            return false;
        }
        return false;
    }

    public static boolean uriEndsWith(String uri, String ending) {
        int queryStart = uri.indexOf(63);
        if (queryStart == -1) {
            return uri.endsWith(ending);
        }
        return uri.length() - queryStart >= ending.length() && uri.substring(queryStart - ending.length(), queryStart).equals(ending);
    }

    public static String getFileExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return lastDot != -1 ? filename.substring(lastDot + 1) : "";
    }

    public static String stripFileExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return lastDot != -1 ? filename.substring(0, lastDot) : filename;
    }

    public static boolean isOSCaseSensitive() {
        return OS_CASE_SENSITIVE;
    }

    public static boolean osSensitiveEquals(String s1, String s2) {
        if (OS_CASE_SENSITIVE) {
            return s1.equals(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean osSensitiveEndsWith(String str, String suffix) {
        int suffixLen;
        if (OS_CASE_SENSITIVE) {
            return str.endsWith(suffix);
        }
        int strLen = str.length();
        if (strLen < (suffixLen = suffix.length())) {
            return false;
        }
        return str.substring(strLen - suffixLen).equalsIgnoreCase(suffix);
    }
}

