/*
 * Decompiled with CFR 0.152.
 */
package be.lukin.poeditor.tasks;

import be.lukin.poeditor.Config;
import be.lukin.poeditor.tasks.BaseTask;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class PushTask
extends BaseTask {
    @Override
    public void handle() {
        System.out.println("Uploading translations");
        Config config = this.config;
        Path current = Paths.get("", new String[0]);
        boolean override = this.params.getBoolean("override");
        boolean noSleep = this.params.getBoolean("noSleep");
        List<String> languages = this.params.getStringList("languages");
        if (noSleep) {
            System.out.println("- Sleep disabled");
        }
        if (override) {
            System.out.println("- override translations");
        }
        boolean first = true;
        for (String lang : config.getLanguageKeys()) {
            if (languages != null && !languages.contains(lang)) continue;
            if (!noSleep && !first) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            File langFile = new File(current.toAbsolutePath().toString(), config.getLanguage(lang));
            this.client.uploadLanguage(config.getProjectId(), langFile, lang, override);
            System.out.println("- lang uploaded: " + lang);
            first = false;
        }
    }
}

