/*
 * Decompiled with CFR 0.152.
 */
package be.lukin.poeditor.tasks;

import be.lukin.poeditor.models.Project;
import be.lukin.poeditor.models.UploadDetails;
import be.lukin.poeditor.tasks.BaseTask;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class InitTask
extends BaseTask {
    @Override
    public void handle() {
        System.out.println("Initializing");
        Project details = this.client.getProject(this.config.getProjectId());
        if (details != null) {
            Path current = Paths.get("", new String[0]);
            if (this.config.getTerms() != null) {
                File termsFile = new File(current.toAbsolutePath().toString(), this.config.getTerms());
                UploadDetails ud = this.client.uploadTerms(this.config.getProjectId(), termsFile);
                System.out.println("- terms uploaded: " + ud);
            } else {
                System.out.println("- no terms defined");
            }
            for (String lang : this.config.getLanguageKeys()) {
                this.client.addProjectLanguage(this.config.getProjectId(), lang);
                System.out.println("- lang added: " + lang);
                File langFile = new File(current.toAbsolutePath().toString(), this.config.getLanguage(lang));
                this.client.uploadLanguage(this.config.getProjectId(), langFile, lang, true);
                System.out.println("- lang uploaded: " + lang);
            }
        } else {
            System.out.println("Project with id '" + this.config.getProjectId() + "' doesn't exist.");
        }
    }
}

