/*
 * Decompiled with CFR 0.152.
 */
package be.lukin.poeditor;

import be.lukin.poeditor.ApiUtils;
import be.lukin.poeditor.FileTypeEnum;
import be.lukin.poeditor.FilterByEnum;
import be.lukin.poeditor.POEditorService;
import be.lukin.poeditor.models.Comment;
import be.lukin.poeditor.models.CommentsDetails;
import be.lukin.poeditor.models.Contributor;
import be.lukin.poeditor.models.FileExport;
import be.lukin.poeditor.models.Language;
import be.lukin.poeditor.models.Project;
import be.lukin.poeditor.models.Term;
import be.lukin.poeditor.models.TermsDetails;
import be.lukin.poeditor.models.UploadDetails;
import be.lukin.poeditor.response.AddCommentsResponse;
import be.lukin.poeditor.response.ContributorsResponse;
import be.lukin.poeditor.response.EditTermsResponse;
import be.lukin.poeditor.response.LanguagesResponse;
import be.lukin.poeditor.response.ProjectDetailResponse;
import be.lukin.poeditor.response.ResponseWrapper;
import be.lukin.poeditor.response.UploadResponse;
import be.lukin.poeditor.response.ViewTermsResponse;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.mime.TypedFile;

public class POEditorClient {
    public static final String HOST = "https://poeditor.com/api/";
    private static final Logger LOG = Logger.getLogger(POEditorClient.class.getName());
    private String apiKey;
    private String endpoint;
    private RestAdapter.LogLevel logLevel = RestAdapter.LogLevel.NONE;
    private POEditorService service;

    public POEditorClient(String apiKey) {
        this(apiKey, HOST, RestAdapter.LogLevel.NONE);
    }

    public POEditorClient(String apiKey, String endpoint, RestAdapter.LogLevel logLevel) {
        Objects.requireNonNull(apiKey, "apiKey is required");
        Objects.requireNonNull(endpoint, "endpoint is required");
        this.apiKey = apiKey;
        this.endpoint = endpoint;
        this.logLevel = logLevel != null ? logLevel : RestAdapter.LogLevel.NONE;
        this.init();
    }

    private void init() {
        if (this.service == null) {
            this.service = (POEditorService)this.getAdapter().create(POEditorService.class);
        }
    }

    private RestAdapter getAdapter() {
        RequestInterceptor requestInterceptor = new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                requestFacade.addHeader("Accept", "application/json");
            }
        };
        return new RestAdapter.Builder().setLogLevel(this.logLevel).setRequestInterceptor(requestInterceptor).setClient((Client)new OkClient()).setEndpoint(this.endpoint).build();
    }

    public List<Project> getProjects() {
        return this.service.getProjects((String)"list_projects", (String)this.apiKey).list;
    }

    public Project getProject(String projectId) {
        ProjectDetailResponse pdr = this.service.getProject("view_project", this.apiKey, projectId);
        ApiUtils.checkResponse(pdr.response);
        return pdr.item;
    }

    public Project createProject(String name) {
        ResponseWrapper wrapper = this.service.createProject("create_project", this.apiKey, name);
        ApiUtils.checkResponse(wrapper.response);
        if ("200".equals(wrapper.response.code) && wrapper.response.item != null) {
            return this.getProject(Integer.toString(wrapper.response.item.id));
        }
        return null;
    }

    public List<Language> getAvailableLanguages() {
        Map<String, String> map = this.service.getAvailableLanguages((String)"available_languages", (String)this.apiKey).list;
        ArrayList<Language> list = new ArrayList<Language>();
        for (Map.Entry<String, String> e : map.entrySet()) {
            list.add(new Language(e.getKey(), e.getValue()));
        }
        return list;
    }

    public List<Language> getProjectLanguages(String projectId) {
        LanguagesResponse lr = this.service.getProjectLanguages("list_languages", this.apiKey, projectId);
        ApiUtils.checkResponse(lr.response);
        return lr.list;
    }

    public boolean addProjectLanguage(String projectId, String language) {
        ResponseWrapper wrapper = this.service.editProjectLanguage("add_language", this.apiKey, projectId, language);
        return "200".equals(wrapper.response.code);
    }

    public boolean deleteProjectLanguage(String projectId, String language) {
        ResponseWrapper wrapper = this.service.editProjectLanguage("delete_language", this.apiKey, projectId, language);
        ApiUtils.checkResponse(wrapper.response);
        return "200".equals(wrapper.response.code);
    }

    public boolean setProjectReferenceLanguage(String projectId, String language) {
        ResponseWrapper wrapper = this.service.editProjectLanguage("set_reference_language", this.apiKey, projectId, language);
        ApiUtils.checkResponse(wrapper.response);
        return "200".equals(wrapper.response.code);
    }

    public boolean clearProjectReferenceLanguage(String projectId, String language) {
        ResponseWrapper wrapper = this.service.clearProjectReferenceLanguage("clear_reference_language", this.apiKey, projectId);
        ApiUtils.checkResponse(wrapper.response);
        return "200".equals(wrapper.response.code);
    }

    public List<Contributor> getProjectContributors(String projectId) {
        ContributorsResponse cr = this.service.getContributors("list_contributors", this.apiKey, projectId);
        ApiUtils.checkResponse(cr.response);
        return cr.list;
    }

    public boolean addAdministrator(String projectId, String name, String email) {
        ResponseWrapper wrapper = this.service.addProjectMember("add_contributor", this.apiKey, projectId, name, email, null, 1);
        return "200".equals(wrapper.response.code);
    }

    public boolean addContributor(String projectId, String name, String email, String language) {
        ResponseWrapper wrapper = this.service.addProjectMember("add_contributor", this.apiKey, projectId, name, email, language, 0);
        ApiUtils.checkResponse(wrapper.response);
        return "200".equals(wrapper.response.code);
    }

    public TermsDetails addTerms(String projectId, List<Term> terms) {
        String jsonTerms = new Gson().toJson(terms);
        EditTermsResponse atr = this.service.editTerms("add_terms", this.apiKey, projectId, jsonTerms);
        ApiUtils.checkResponse(atr.response);
        return atr.details;
    }

    public TermsDetails deleteTerms(String projectId, List<Term> terms) {
        String jsonTerms = new Gson().toJson(terms);
        EditTermsResponse etr = this.service.editTerms("delete_terms", this.apiKey, projectId, jsonTerms);
        ApiUtils.checkResponse(etr.response);
        return etr.details;
    }

    public File export(String projectId, String language, FileTypeEnum fte, FilterByEnum[] filters) {
        return this.export(projectId, language, fte, filters, null, null);
    }

    public File export(String projectId, String language, FileTypeEnum fte, FilterByEnum[] filters, File exportFile, String[] tags) {
        String tagsStr = tags != null && tags.length > 0 ? new Gson().toJson((Object)tags) : null;
        FileExport fe = this.service.export("export", this.apiKey, projectId, language, fte.name().toLowerCase(), FilterByEnum.toStringArray(filters), tagsStr);
        try {
            if (exportFile != null) {
                exportFile.createNewFile();
            } else {
                exportFile = File.createTempFile("poeditor-export-file-", ".tmp");
            }
            if (fe.item != null) {
                URL website = new URL(fe.item);
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(exportFile);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                return exportFile;
            }
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.SEVERE, e.toString(), e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.toString(), e);
        }
        return null;
    }

    public UploadDetails uploadTerms(String projectId, File translationFile) {
        return this.uploadTerms(projectId, translationFile, null, null, null);
    }

    public UploadDetails uploadTerms(String projectId, File translationFile, String[] allTags, String[] newTags, String[] obsoleteTags) {
        HashMap<String, String[]> tags = new HashMap<String, String[]>();
        if (allTags != null) {
            tags.put("all", allTags);
        }
        if (newTags != null) {
            tags.put("new", newTags);
        }
        if (obsoleteTags != null) {
            tags.put("obsolete", obsoleteTags);
        }
        String tagsStr = new Gson().toJson(tags);
        TypedFile typedFile = new TypedFile("application/xml", translationFile);
        UploadResponse ur = this.service.upload("upload", this.apiKey, projectId, "terms", typedFile, null, "0", tagsStr);
        ApiUtils.checkResponse(ur.response);
        return ur.details;
    }

    public UploadDetails uploadLanguage(String projectId, File translationFile, final String language, boolean overwrite) {
        TypedFile typedFile = new TypedFile("application/xml", translationFile);
        String _overwrite = overwrite ? "1" : "0";
        UploadResponse ur = this.service.upload("upload", this.apiKey, projectId, "definitions", typedFile, language, _overwrite, null);
        HashMap<String, String> context = new HashMap<String, String>(){
            {
                this.put("lang", language);
            }
        };
        ApiUtils.checkResponse(ur.response, (Map<String, String>)context);
        return ur.details;
    }

    public List<Term> viewTerms(String projectId) {
        ViewTermsResponse response = this.service.viewProjectTerms("view_terms", this.apiKey, projectId, null);
        ApiUtils.checkResponse(response.response);
        return response.list;
    }

    public CommentsDetails addComments(String projectId, List<Comment> comments) {
        String jsonComments = new Gson().toJson(comments);
        AddCommentsResponse response = this.service.addComment("add_comment", this.apiKey, projectId, jsonComments);
        ApiUtils.checkResponse(response.response);
        return response.details;
    }

    public TermsDetails syncTerms(String projectId, List<Term> terms) {
        String jsonTerms = new Gson().toJson(terms);
        EditTermsResponse response = this.service.syncTerms("sync_terms", this.apiKey, projectId, jsonTerms);
        ApiUtils.checkResponse(response.response);
        return response.details;
    }

    public String toString() {
        return "POEditorClient{endpoint='" + this.endpoint + '\'' + ", apiKey='" + this.apiKey + '\'' + '}';
    }

    public static class Action {
        public static final String LIST_PROJECTS = "list_projects";
        public static final String VIEW_PROJECT = "view_project";
        public static final String VIEW_TERMS = "view_terms";
        public static final String CREATE_PROJECT = "create_project";
        public static final String LIST_LANGUAGES = "list_languages";
        public static final String AVAILABLE_LANGUAGES = "available_languages";
        public static final String LIST_CONTRIBUTORS = "list_contributors";
        public static final String ADD_CONTRIBUTOR = "add_contributor";
        public static final String ADD_TERMS = "add_terms";
        public static final String ADD_COMMENTS = "add_comment";
        public static final String DELETE_TERMS = "delete_terms";
        public static final String ADD_LANGUAGE = "add_language";
        public static final String DELETE_LANGUAGE = "delete_language";
        public static final String SET_REFERENCE_LANGUAGE = "set_reference_language";
        public static final String CLEAR_REFERENCE_LANGUAGE = "clear_reference_language";
        public static final String EXPORT = "export";
        public static final String SYNC_TERMS = "sync_terms";
    }
}

