/*
 * Decompiled with CFR 0.152.
 */
package be.lukin.poeditor;

import be.lukin.poeditor.exceptions.ApiException;
import be.lukin.poeditor.exceptions.InvalidTokenException;
import be.lukin.poeditor.exceptions.PermissionDeniedException;
import be.lukin.poeditor.models.Response;
import java.util.Map;

public abstract class ApiUtils {
    public static void checkResponse(Response response) {
        ApiUtils.checkResponse(response, null);
    }

    public static void checkResponse(Response response, Map<String, String> context) {
        if ("403".equals(response.code)) {
            throw new PermissionDeniedException();
        }
        if ("4011".equals(response.code)) {
            throw new InvalidTokenException();
        }
        if ("4043".equals(response.code)) {
            String lang = context != null ? context.get("lang") : null;
            String msg = String.format("Wrong language code: %s", lang);
            throw new ApiException(response.status, response.code, msg);
        }
        if (!"200".equals(response.code)) {
            throw new ApiException(response.status, response.code, response.message);
        }
    }
}

