/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.cors.CorsConfiguration;

class RegexCorsConfiguration
extends CorsConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexCorsConfiguration.class);
    private final List<Pattern> allowedOriginsRegex = new ArrayList<Pattern>();

    RegexCorsConfiguration() {
    }

    RegexCorsConfiguration(CorsConfiguration other) {
        this();
        this.setAllowCredentials(other.getAllowCredentials());
        this.setAllowedOrigins(other.getAllowedOrigins());
        this.setAllowedHeaders(other.getAllowedHeaders());
        this.setAllowedMethods(other.getAllowedMethods());
        this.setExposedHeaders(other.getExposedHeaders());
        this.setMaxAge(other.getMaxAge());
    }

    public void addAllowedOrigin(String origin) {
        super.addAllowedOrigin(origin);
        try {
            this.allowedOriginsRegex.add(Pattern.compile(origin));
        }
        catch (PatternSyntaxException e) {
            LOGGER.warn("Wrong syntax for the origin {} as a regular expression. If this origin is not supposed to be a regular expression, just ignore this error.", (Object)origin);
        }
    }

    public String checkOrigin(String requestOrigin) {
        String result = super.checkOrigin(requestOrigin);
        return result != null ? result : this.checkOriginWithRegularExpression(requestOrigin);
    }

    private String checkOriginWithRegularExpression(String requestOrigin) {
        return this.allowedOriginsRegex.stream().filter(pattern -> pattern.matcher(requestOrigin).matches()).map(pattern -> requestOrigin).findFirst().orElse(null);
    }

    public CorsConfiguration combine(CorsConfiguration other) {
        Long maxAge;
        if (other == null) {
            return this;
        }
        RegexCorsConfiguration config = new RegexCorsConfiguration(this);
        config.setAllowedOrigins(this.combine(this.getAllowedOrigins(), other.getAllowedOrigins()));
        config.setAllowedMethods(this.combine(this.getAllowedMethods(), other.getAllowedMethods()));
        config.setAllowedHeaders(this.combine(this.getAllowedHeaders(), other.getAllowedHeaders()));
        config.setExposedHeaders(this.combine(this.getExposedHeaders(), other.getExposedHeaders()));
        Boolean allowCredentials = other.getAllowCredentials();
        if (allowCredentials != null) {
            config.setAllowCredentials(allowCredentials);
        }
        if ((maxAge = other.getMaxAge()) != null) {
            config.setMaxAge(maxAge);
        }
        return config;
    }

    private List<String> combine(List<String> source, List<String> other) {
        if (other == null || other.contains("*")) {
            return source;
        }
        if (source == null || source.contains("*")) {
            return other;
        }
        HashSet<String> combined = new HashSet<String>(source);
        combined.addAll(other);
        return new ArrayList<String>(combined);
    }
}

