/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import be.looorent.security.jwt.JwtTokenParser;
import be.looorent.security.jwt.UnauthenticatedToken;
import be.looorent.security.jwt.UserDetailsFactory;
import io.jsonwebtoken.Claims;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

class AuthenticationProviderImpl
implements AuthenticationProvider {
    private final UserDetailsFactory userDetailsFactory;
    private final JwtTokenParser tokenParser;

    @Autowired
    AuthenticationProviderImpl(JwtTokenParser tokenParser, UserDetailsFactory userDetailsFactory) {
        this.tokenParser = tokenParser;
        this.userDetailsFactory = userDetailsFactory;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UnauthenticatedToken token = (UnauthenticatedToken)authentication;
        Claims claims = this.tokenParser.parse(token);
        UserDetails principal = this.userDetailsFactory.createFrom(claims, token.getRequest());
        return token.authenticate(principal);
    }

    public boolean supports(Class<?> authentication) {
        return UnauthenticatedToken.class.isAssignableFrom(authentication);
    }
}

