/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import be.looorent.security.jwt.AuthenticationProperties;
import be.looorent.security.jwt.JwtExceptionType;
import be.looorent.security.jwt.TokenException;
import be.looorent.security.jwt.UnauthenticatedToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import org.springframework.beans.factory.annotation.Autowired;

class JwtTokenParser {
    private final JwtParser jwtVerifier;

    @Autowired
    JwtTokenParser(AuthenticationProperties authenticationProperties) {
        this.jwtVerifier = Jwts.parser().setSigningKey(authenticationProperties.getTokenSecretKey()).requireIssuer(authenticationProperties.getTokenIssuer());
    }

    public Claims parse(UnauthenticatedToken token) throws TokenException {
        try {
            return (Claims)this.jwtVerifier.parseClaimsJws(token.getJwtAsString()).getBody();
        }
        catch (UnsupportedJwtException e) {
            throw new TokenException(JwtExceptionType.UNSUPPORTED);
        }
        catch (MalformedJwtException e) {
            throw new TokenException(JwtExceptionType.MALFORMED);
        }
        catch (SignatureException e) {
            throw new TokenException(JwtExceptionType.WRONG_SIGNATURE);
        }
        catch (ExpiredJwtException e) {
            throw new TokenException(JwtExceptionType.EXPIRED);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage());
        }
    }
}

