/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import be.looorent.security.jwt.TokenException;
import be.looorent.security.jwt.UserDoesNotExistException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

class AuthenticationEntryPointImpl
implements AuthenticationEntryPoint {
    private static final String OPTIONS_METHOD = "OPTIONS";
    private static final String USER_DOES_NOT_EXISTS_HEADER = "Authentication-User-Does-Not-Exist";
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private static final String USER_DOES_NOT_EXIST = "user_does_not_exist";
    private static final String TRUE = "true";

    AuthenticationEntryPointImpl() {
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        if (this.isPreflight(request)) {
            response.setStatus(204);
        } else if (authenticationException instanceof UserDoesNotExistException) {
            this.userDoesNotExistYet(response);
        } else if (authenticationException instanceof TokenException) {
            this.tokenHasBeenRefused(response, (TokenException)authenticationException);
        } else {
            this.requestIsRefused(response, authenticationException);
        }
    }

    private void requestIsRefused(HttpServletResponse response, AuthenticationException authException) throws IOException {
        this.formatResponse(response, 403, authException.getMessage());
    }

    private void tokenHasBeenRefused(HttpServletResponse response, TokenException authException) throws IOException {
        this.formatResponse(response, 401, authException.getMessage());
    }

    private void userDoesNotExistYet(HttpServletResponse response) throws IOException {
        this.formatResponse(response, 412, USER_DOES_NOT_EXIST);
        response.setHeader(USER_DOES_NOT_EXISTS_HEADER, TRUE);
    }

    private void formatResponse(HttpServletResponse response, int status, String reason) throws IOException {
        response.setContentType(APPLICATION_JSON);
        response.setCharacterEncoding(UTF_8);
        response.sendError(status, "{\"reason\": \"" + reason + "\"}");
    }

    private boolean isPreflight(HttpServletRequest request) {
        return OPTIONS_METHOD.equals(request.getMethod());
    }
}

