/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import be.looorent.security.jwt.AuthenticationCorsFilter;
import be.looorent.security.jwt.AuthenticationEntryPointImpl;
import be.looorent.security.jwt.AuthenticationFilter;
import be.looorent.security.jwt.AuthenticationProperties;
import be.looorent.security.jwt.AuthenticationProviderImpl;
import be.looorent.security.jwt.HttpHeaderProperties;
import be.looorent.security.jwt.JwtTokenParser;
import be.looorent.security.jwt.UserDetailsFactory;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Order(value=0x7FFFFFF8)
@EnableConfigurationProperties(value={HttpHeaderProperties.class, AuthenticationProperties.class})
class JwtSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private UserDetailsFactory userDetailsFactory;
    @Autowired
    private HttpHeaderProperties httpHeaderProperties;
    @Autowired
    private AuthenticationProperties authenticationProperties;

    JwtSecurityConfiguration() {
    }

    @Bean(name={"jwtAuthenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public AuthenticationCorsFilter corsFilter() {
        return new AuthenticationCorsFilter(this.httpHeaderProperties);
    }

    @Bean
    public AuthenticationProviderImpl jwtAuthenticationProvider() {
        return new AuthenticationProviderImpl(this.tokenParser(), this.userDetailsFactory);
    }

    @Bean
    @DependsOn
    public JwtTokenParser tokenParser() {
        return new JwtTokenParser(this.authenticationProperties);
    }

    @Bean
    public AuthenticationEntryPointImpl jwtEntryPoint() {
        return new AuthenticationEntryPointImpl();
    }

    @Bean
    public AuthenticationFilter jwtFilter(AuthenticationEntryPointImpl entryPoint) throws Exception {
        return new AuthenticationFilter(this.authenticationManagerBean(), entryPoint);
    }

    @Bean
    public FilterRegistrationBean jwtAuthenticationFilterRegistration(AuthenticationFilter filter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setEnabled(false);
        return filterRegistrationBean;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider());
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        http.addFilterAfter((Filter)this.jwtFilter(this.jwtEntryPoint()), SecurityContextPersistenceFilter.class).addFilterBefore((Filter)this.corsFilter(), AuthenticationFilter.class);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{this.authenticationProperties.getPublicRoute()})).permitAll().anyRequest()).authenticated();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER);
    }
}

