/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import be.looorent.security.jwt.AuthenticationProperties;
import be.looorent.security.jwt.TokenException;
import be.looorent.security.jwt.UnauthenticatedToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import org.springframework.beans.factory.annotation.Autowired;

class JwtTokenParser {
    private final JwtParser jwtVerifier;

    @Autowired
    JwtTokenParser(AuthenticationProperties authenticationProperties) {
        this.jwtVerifier = Jwts.parser().setSigningKey(authenticationProperties.getTokenSecretKey()).requireIssuer(authenticationProperties.getTokenIssuer());
    }

    public Claims parse(UnauthenticatedToken token) throws TokenException {
        try {
            return (Claims)this.jwtVerifier.parseClaimsJws(token.getJwtAsString()).getBody();
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage());
        }
    }
}

