/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.security.jwt;

import be.looorent.security.jwt.TokenException;
import be.looorent.security.jwt.UserDoesNotExistException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

class AuthenticationEntryPointImpl
implements AuthenticationEntryPoint {
    private static final String OPTIONS_METHOD = "OPTIONS";
    private static final String USER_DOES_NOT_EXISTS_HEADER = "Authentication-User-Does-Not-Exist";

    AuthenticationEntryPointImpl() {
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        if (this.isPreflight(request)) {
            response.setStatus(204);
        } else if (authenticationException instanceof UserDoesNotExistException) {
            this.userDoesNotExistYet(response);
        } else if (authenticationException instanceof TokenException) {
            this.tokenHasBeenRefused(response, authenticationException);
        } else {
            this.requestIsRefused(response, authenticationException);
        }
    }

    private void requestIsRefused(HttpServletResponse response, AuthenticationException authException) throws IOException {
        response.sendError(403, authException.getMessage());
        response.getWriter().println(this.formatErrorMessage((Exception)authException, 403));
    }

    private void tokenHasBeenRefused(HttpServletResponse response, AuthenticationException authException) throws IOException {
        response.sendError(401, authException.getMessage());
        response.getWriter().println(this.formatErrorMessage((Exception)authException, 401));
    }

    private void userDoesNotExistYet(HttpServletResponse response) throws IOException {
        response.sendError(412, "This user does not exist.");
        response.setHeader(USER_DOES_NOT_EXISTS_HEADER, "true");
        response.getWriter().println("User does not exists");
    }

    private String formatErrorMessage(Exception authenticationException, int statusCode) {
        return "HTTP Status " + statusCode + " - " + authenticationException.getMessage();
    }

    private boolean isPreflight(HttpServletRequest request) {
        return OPTIONS_METHOD.equals(request.getMethod());
    }
}

