/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.subscriber.BrokerSubscriptionConfiguration;
import be.looorent.jflu.subscriber.QueueListener;
import be.looorent.jflu.subscriber.RabbitMQConnectionException;
import be.looorent.jflu.subscriber.RabbitMQPropertyName;
import be.looorent.jflu.subscriber.RabbitMQQueueListener;
import be.looorent.jflu.subscriber.RabbitMQSubscriptionRepository;
import be.looorent.jflu.subscriber.SubscriptionRepository;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQSubscriptionConfiguration
implements BrokerSubscriptionConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQSubscriptionConfiguration.class);
    private static final String TOPIC_EXCHANGE_TYPE = "topic";
    private static final String DEFAULT_EXCHANGE_NAME = "jflu";
    private static final int DEFAULT_PREFETCH_SIZE = 10;
    private static final boolean DEFAULT_QUEUE_DURABILITY = false;
    private final Connection connection;
    private final Channel channel;
    private final String exchangeName;
    private final String queueName;

    public RabbitMQSubscriptionConfiguration(Properties properties) throws RabbitMQConnectionException {
        try {
            this.connection = this.createFactory(properties).newConnection();
            this.channel = this.createChannel(this.connection, properties);
            this.queueName = this.createQueue(this.channel, properties);
            this.exchangeName = this.connectExchange(properties);
        }
        catch (Exception e) {
            LOG.error("An error occurred when creating a connection to RabbitMQ", (Throwable)e);
            throw new RabbitMQConnectionException(e);
        }
    }

    public static final RabbitMQSubscriptionConfiguration createFromSystemProperties() throws RabbitMQConnectionException {
        return new RabbitMQSubscriptionConfiguration(RabbitMQPropertyName.readPropertiesFromEnvironment());
    }

    private String connectExchange(Properties properties) throws IOException {
        String exchangeName = Optional.ofNullable(RabbitMQPropertyName.EXCHANGE_NAME.readFrom(properties)).orElse(DEFAULT_EXCHANGE_NAME);
        boolean durableQueue = Optional.ofNullable(RabbitMQPropertyName.DURABLE_QUEUE.readFrom(properties)).map(Boolean::parseBoolean).orElse(false);
        this.channel.exchangeDeclare(exchangeName, TOPIC_EXCHANGE_TYPE, durableQueue);
        return exchangeName;
    }

    private String createQueue(Channel channel, Properties properties) throws IOException {
        AMQP.Queue.DeclareOk queueDeclaration = channel.queueDeclare(RabbitMQPropertyName.QUEUE_NAME.readFrom(properties), true, false, false, new HashMap());
        return queueDeclaration.getQueue();
    }

    private Channel createChannel(Connection connection, Properties properties) throws IOException {
        Channel channel = connection.createChannel();
        String prefetchProperty = RabbitMQPropertyName.PREFETCH_SIZE.readFrom(properties);
        int prefetchSize = prefetchProperty == null || prefetchProperty.isEmpty() ? 10 : Integer.parseInt(prefetchProperty);
        LOG.info("Prefetch size of queue is set to {}", (Object)prefetchSize);
        channel.basicQos(prefetchSize);
        return channel;
    }

    protected ConnectionFactory createFactory(Properties properties) {
        LOG.debug("Creating RabbitMQ connection factory with properties: {}", (Object)properties);
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(RabbitMQPropertyName.USERNAME.readFrom(properties));
        factory.setPassword(RabbitMQPropertyName.PASSWORD.readFrom(properties));
        factory.setVirtualHost(RabbitMQPropertyName.VIRTUAL_HOST.readFrom(properties));
        factory.setHost(RabbitMQPropertyName.HOST.readFrom(properties));
        factory.setPort(Integer.parseInt(RabbitMQPropertyName.PORT.readFrom(properties)));
        return factory;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public SubscriptionRepository getSubscriptionRepository() {
        return new RabbitMQSubscriptionRepository(this);
    }

    public QueueListener getQueueListener() {
        return new RabbitMQQueueListener(this);
    }
}

