/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.Configuration;
import be.looorent.jflu.Event;
import be.looorent.jflu.subscriber.QueueListener;
import be.looorent.jflu.subscriber.RabbitMQSubscriptionConfiguration;
import be.looorent.jflu.subscriber.SubscriptionRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RabbitMQQueueListener
implements QueueListener {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQQueueListener.class);
    private final RabbitMQSubscriptionConfiguration configuration;
    private final ObjectMapper jsonMapper;

    public RabbitMQQueueListener(RabbitMQSubscriptionConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
        this.jsonMapper = Configuration.getInstance().getDefaultJsonMapper();
    }

    public void listen(final SubscriptionRepository subscriptionRepository) {
        if (subscriptionRepository == null) {
            throw new IllegalArgumentException("subscriptionRepository must not be null");
        }
        try {
            final Channel channel = this.configuration.getChannel();
            channel.basicConsume(this.configuration.getQueueName(), false, (Consumer)new DefaultConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    super.handleDelivery(consumerTag, envelope, properties, body);
                    Event event = (Event)RabbitMQQueueListener.this.jsonMapper.readValue(body, Event.class);
                    subscriptionRepository.findAllSubscriptionsFor(event).forEach(subscription -> subscription.consume(event));
                    channel.basicAck(envelope.getDeliveryTag(), false);
                    LOG.debug("Event acked: {}", (Object)event.getId());
                }
            });
        }
        catch (IOException e) {
            LOG.error("An error occurred when consuming events", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

