/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber.rabbitmq;

import be.looorent.jflu.RoutingKeyBuilder;
import be.looorent.jflu.subscriber.Subscription;
import be.looorent.jflu.subscriber.SubscriptionQuery;
import be.looorent.jflu.subscriber.SubscriptionRepository;
import be.looorent.jflu.subscriber.rabbitmq.RabbitMQSubscriptionConfiguration;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RabbitMQSubscriptionRepository
extends SubscriptionRepository {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQSubscriptionRepository.class);
    private final RabbitMQSubscriptionConfiguration configuration;

    public RabbitMQSubscriptionRepository(RabbitMQSubscriptionConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
    }

    public void register(Subscription subscription) {
        if (subscription == null) {
            throw new IllegalArgumentException("subscription must not be null");
        }
        String queue = this.configuration.getQueueName();
        String exchange = this.configuration.getExchangeName();
        try {
            String routingKey = this.convertToRoutingKey(subscription.getQuery());
            LOG.info("Binding RabbitMQ Queue '{}' to Exchange '{}' using routing key: {}", new Object[]{queue, exchange, routingKey});
            this.configuration.getChannel().queueBind(queue, exchange, routingKey);
        }
        catch (IOException e) {
            LOG.error("An error occurred when binding RabbitMQ Queue '{}' to Exchange '{}' for subscription: {}", new Object[]{queue, exchange, subscription.getName(), e});
            throw new IllegalArgumentException(e);
        }
        super.register(subscription);
    }

    protected String convertToRoutingKey(SubscriptionQuery query) {
        return RoutingKeyBuilder.create().withStatus(query.getStatus()).withEmitter(query.getEmitter()).withKind(query.getKind()).withName(query.getName()).build();
    }
}

