/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.subscriber.ConsumptionException;
import be.looorent.jflu.subscriber.ConsumptionExceptionHandler;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQExceptionHandler
extends DefaultExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQExceptionHandler.class);
    private static final String CONSUMPTION_EXCEPTION_HANDLER_IMPLEMENTATION_PROPERTY = "CONSUMPTION_EXCEPTION_HANDLER_IMPLEMENTATION";
    private ConsumptionExceptionHandler consumptionExceptionHandler = this.initConsumptionExceptionHandler();

    RabbitMQExceptionHandler() {
    }

    public void handleConsumerException(Channel channel, Throwable exception, Consumer consumer, String consumerTag, String methodName) {
        super.handleConsumerException(channel, exception, consumer, consumerTag, methodName);
        if (!(exception instanceof ConsumptionException)) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        this.handleConsumptionException((ConsumptionException)exception);
    }

    private void handleConsumptionException(ConsumptionException exception) {
        if (this.consumptionExceptionHandler == null) {
            throw new RuntimeException((Throwable)exception);
        }
        this.consumptionExceptionHandler.handle(exception);
    }

    private ConsumptionExceptionHandler initConsumptionExceptionHandler() {
        String consumptionExceptionHandlerClassName = this.readConsumptionExceptionHandlerClassName();
        if (consumptionExceptionHandlerClassName != null && !consumptionExceptionHandlerClassName.isEmpty()) {
            try {
                Class<?> handlerClass = Class.forName(consumptionExceptionHandlerClassName);
                return handlerClass.asSubclass(ConsumptionExceptionHandler.class).newInstance();
            }
            catch (ClassNotFoundException e) {
                LOG.error("{} property present but class {} not found in the classpath", (Object)CONSUMPTION_EXCEPTION_HANDLER_IMPLEMENTATION_PROPERTY, (Object)consumptionExceptionHandlerClassName);
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                LOG.error("class {} found but does not extends {}", (Object)consumptionExceptionHandlerClassName, (Object)ConsumptionExceptionHandler.class.getSimpleName());
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Unable to instantiate class {}", (Object)consumptionExceptionHandlerClassName);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected String readConsumptionExceptionHandlerClassName() {
        return System.getenv(CONSUMPTION_EXCEPTION_HANDLER_IMPLEMENTATION_PROPERTY);
    }
}

