/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.springmvc;

import be.looorent.jflu.publisher.EventPublisher;
import be.looorent.jflu.request.RequestEventFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RequestInterceptor
extends HandlerInterceptorAdapter {
    private static final String JFLU_START_TIME = "jfluStartTime";
    private static final String JFLU_REQUEST_ID = "jfluRequestId";
    private final EventPublisher publisher;
    private final RequestEventFactory factory;

    public RequestInterceptor(EventPublisher publisher) {
        if (publisher == null) {
            throw new IllegalArgumentException("publisher must not be null");
        }
        this.publisher = publisher;
        this.factory = new RequestEventFactory();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute(JFLU_START_TIME, (Object)System.currentTimeMillis());
        request.setAttribute(JFLU_REQUEST_ID, (Object)UUID.randomUUID());
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
        HandlerMethod method = (HandlerMethod)handler;
        int duration = (int)(System.currentTimeMillis() - (Long)request.getAttribute(JFLU_START_TIME));
        UUID requestId = (UUID)request.getAttribute(JFLU_REQUEST_ID);
        this.publisher.publish(this.factory.createEvent(requestId, method.getMethod().getDeclaringClass().getSimpleName(), method.getMethod().getName(), request.getRequestURL().toString(), response.getStatus(), request.getHeader("User-Agent"), duration, this.extractParametersFrom(request), null));
    }

    private Map<String, List<String>> extractParametersFrom(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().filter(entry -> entry.getKey() != JFLU_REQUEST_ID && entry.getKey() != JFLU_START_TIME).collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList((String[])entry.getValue())));
    }
}

