/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.publisher.rabbitmq;

import be.looorent.jflu.publisher.rabbitmq.RabbitMQPropertyName;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RabbitMQConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQConnectionFactory.class);
    private static final int MAXIMUM_CONNECTION_ATTEMPTS = 30;
    private static final int CONNECTION_ATTEMPT_INTERVAL_IN_MS = 1000;
    private static final boolean DEFAULT_WAIT_FOR_CONNECTION = true;

    RabbitMQConnectionFactory() {
    }

    Connection connect(Properties properties) {
        boolean waitForConnection = Optional.ofNullable(RabbitMQPropertyName.WAIT_FOR_CONNECTION.readFrom(properties)).map(Boolean::parseBoolean).orElse(true);
        ConnectionFactory factory = this.createFactory(properties);
        LOG.info("Waiting for a RabbitMQ connection? -> {}", (Object)waitForConnection);
        if (waitForConnection) {
            return this.waitForConnection(factory);
        }
        return this.connect(factory);
    }

    private Connection connect(ConnectionFactory factory) {
        try {
            return factory.newConnection();
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private Connection waitForConnection(ConnectionFactory factory) {
        Connection connection = null;
        int attempt = 0;
        while (connection == null) {
            ++attempt;
            try {
                connection = this.connect(factory);
            }
            catch (RuntimeException e) {
                this.waitOrStop(attempt, e);
            }
        }
        return connection;
    }

    private ConnectionFactory createFactory(Properties properties) {
        LOG.debug("Creating RabbitMQ connection factory with properties: {}", (Object)properties);
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(RabbitMQPropertyName.USERNAME.readFrom(properties));
        factory.setPassword(RabbitMQPropertyName.PASSWORD.readFrom(properties));
        factory.setVirtualHost(RabbitMQPropertyName.VIRTUAL_HOST.readFrom(properties));
        factory.setHost(RabbitMQPropertyName.HOST.readFrom(properties));
        factory.setPort(Integer.parseInt(RabbitMQPropertyName.PORT.readFrom(properties)));
        return factory;
    }

    private void waitOrStop(int attempt, RuntimeException error) {
        if (attempt == 30) {
            LOG.error("The maximum of attempts has been reached ({}). Stopping the consumer.", (Object)30);
            throw new RuntimeException(error);
        }
        this.wait(attempt);
    }

    private void wait(int attempt) {
        try {
            LOG.error("RabbitMQ is not ready yet, waiting {} ms (attempt {})", (Object)1000, (Object)attempt);
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            LOG.error("Error when waiting for a connection", (Throwable)e1);
            throw new RuntimeException(e1);
        }
    }
}

