/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.publisher;

import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;

public enum RabbitMQPropertyName {
    USERNAME("rabbitmq.username"),
    PASSWORD("rabbitmq.password"),
    HOST("rabbitmq.host"),
    PORT("rabbitmq.port"),
    VIRTUAL_HOST("rabbitmq.virtualHost"),
    EXCHANGE_NAME("rabbitmq.exchangeName");

    private final String propertyName;

    private RabbitMQPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String readFrom(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        return properties.getProperty(this.propertyName);
    }

    public void writeTo(Properties properties, Object value) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        properties.setProperty(this.propertyName, String.valueOf(value));
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getEnvironmentVariableName() {
        return this.propertyName.toUpperCase().replace(".", "_");
    }

    public static final Properties readPropertiesFromEnvironment() {
        Properties properties = new Properties();
        properties.putAll(Arrays.stream(RabbitMQPropertyName.values()).collect(Collectors.toMap(RabbitMQPropertyName::getPropertyName, property -> {
            String value = System.getenv(property.getEnvironmentVariableName());
            return value == null ? "" : value;
        })));
        return properties;
    }
}

