/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.publisher;

import be.looorent.jflu.Configuration;
import be.looorent.jflu.Event;
import be.looorent.jflu.RoutingKeyBuilder;
import be.looorent.jflu.publisher.EventPublisher;
import be.looorent.jflu.publisher.PublishingException;
import be.looorent.jflu.publisher.RabbitMQPropertyName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQEventTopicPublisher
implements EventPublisher,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQEventTopicPublisher.class);
    private static final String TOPIC_EXCHANGE_TYPE = "topic";
    private static final String DEFAULT_EXCHANGE_NAME = "jflu";
    private Connection connection;
    private Channel channel;
    private String exchangeName;
    private ObjectMapper jsonMapper;

    public RabbitMQEventTopicPublisher(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        try {
            this.jsonMapper = this.createJsonMapper();
            this.connection = this.createFactory(properties).newConnection();
            this.channel = this.connection.createChannel();
            this.exchangeName = Optional.ofNullable(RabbitMQPropertyName.EXCHANGE_NAME.readFrom(properties)).orElse(DEFAULT_EXCHANGE_NAME);
            LOG.info("Connect RabbitMQ with topic exchange type to exchange: {}", (Object)this.exchangeName);
            this.channel.exchangeDeclare(this.exchangeName, TOPIC_EXCHANGE_TYPE);
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private ConnectionFactory createFactory(Properties properties) {
        LOG.debug("Creating RabbitMQ connection factory with properties: {}", (Object)properties);
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(RabbitMQPropertyName.USERNAME.readFrom(properties));
        factory.setPassword(RabbitMQPropertyName.PASSWORD.readFrom(properties));
        factory.setVirtualHost(RabbitMQPropertyName.VIRTUAL_HOST.readFrom(properties));
        factory.setHost(RabbitMQPropertyName.HOST.readFrom(properties));
        factory.setPort(Integer.parseInt(RabbitMQPropertyName.PORT.readFrom(properties)));
        return factory;
    }

    public void publish(Event event) throws PublishingException {
        String routingKey = this.createRoutingKeyFrom(event);
        LOG.debug("Publishing event {} with routing key : {}", (Object)event.getId(), (Object)routingKey);
        try {
            this.channel.basicPublish(this.exchangeName, routingKey, null, this.jsonMapper.writeValueAsBytes((Object)event));
        }
        catch (IOException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
        this.connection.close();
    }

    protected ObjectMapper createJsonMapper() {
        return Configuration.getInstance().getDefaultJsonMapper();
    }

    protected String createRoutingKeyFrom(Event event) {
        return RoutingKeyBuilder.create().withStatus(event.getStatus()).withEmitter(event.getEmitter()).withKind(event.getKind()).withName(event.getName()).build();
    }
}

