/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.entity;

import be.looorent.jflu.Event;
import be.looorent.jflu.entity.EntityEventFactory;
import be.looorent.jflu.publisher.EventPublisher;
import be.looorent.jflu.publisher.PublishingException;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Metamodel;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityListener
extends EmptyInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EntityListener.class);
    private final Collection<Event> events;
    private final UUID sessionId;
    private final Supplier<EventPublisher> publisher;
    private final EntityEventFactory factory;
    private final Metamodel metamodel;

    public EntityListener(Supplier<EventPublisher> publisher, Supplier<Metamodel> metamodel) {
        if (publisher == null) {
            throw new IllegalArgumentException("publisher must not be null");
        }
        this.events = new ArrayList<Event>();
        this.publisher = publisher;
        this.metamodel = metamodel.get();
        this.factory = new EntityEventFactory();
        this.sessionId = UUID.randomUUID();
    }

    public void afterTransactionCompletion(Transaction tx) {
        if (!tx.getRollbackOnly()) {
            EventPublisher publisher = this.publisher.get();
            try {
                for (Event event : this.events) {
                    publisher.publish(event);
                }
            }
            catch (PublishingException e) {
                LOG.error("An error occurred when publishing an event.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.events.add(this.factory.createEventOnDelete(entity.getClass(), id, this.sessionId));
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        HashMap<String, Object> statePerProperty = new HashMap<String, Object>();
        for (int propertyIndex = 0; propertyIndex < propertyNames.length; ++propertyIndex) {
            Type type = types[propertyIndex];
            if (!this.isSimple(type)) continue;
            statePerProperty.put(propertyNames[propertyIndex], state[propertyIndex]);
        }
        this.events.add(this.factory.createEventOnSave(entity.getClass(), id, statePerProperty, this.sessionId));
        return true;
    }

    private boolean isSimple(Type type) {
        return !type.isCollectionType() && !type.isAssociationType() && !type.isEntityType();
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        HashMap<String, ArrayList> changePerProperty = new HashMap<String, ArrayList>();
        for (int propertyIndex = 0; propertyIndex < propertyNames.length; ++propertyIndex) {
            Type type = types[propertyIndex];
            if (!this.isSimple(type) || Objects.equals(previousState[propertyIndex], currentState[propertyIndex])) continue;
            changePerProperty.put(propertyNames[propertyIndex], Lists.newArrayList((Object[])new Object[]{previousState[propertyIndex], currentState[propertyIndex]}));
        }
        this.events.add(this.factory.createEventOnUpdate(entity.getClass(), id, changePerProperty, this.sessionId));
        return super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
    }
}

