/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.Event;
import be.looorent.jflu.subscriber.Subscription;
import be.looorent.jflu.subscriber.SubscriptionQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionRepository.class);
    private final ConcurrentMap<SubscriptionQuery, List<Subscription>> subscriptionsByQuery = new ConcurrentHashMap<SubscriptionQuery, List<Subscription>>();

    public void register(Subscription subscription) {
        if (subscription == null) {
            throw new IllegalArgumentException("subscription must not be null");
        }
        LOG.info("Register subscription for mapping : {}", (Object)subscription.getName());
        this.subscriptionsByQuery.putIfAbsent(subscription.getQuery(), new ArrayList());
        ((List)this.subscriptionsByQuery.get(subscription.getQuery())).add(subscription);
    }

    public Collection<Subscription> findAllSubscriptionsFor(Event event) {
        return event == null ? new ArrayList<Subscription>() : (Collection)SubscriptionQuery.allQueriesThatMatch(event).stream().flatMap(query -> ((List)this.subscriptionsByQuery.getOrDefault(query, new ArrayList())).stream()).collect(Collectors.toList());
    }
}

