/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.subscriber.BrokerException;
import be.looorent.jflu.subscriber.BrokerSubscriptionConfiguration;
import be.looorent.jflu.subscriber.BrokerSubscriptionConfigurationProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerSubscriptionEnvironmentConfigurationProvider
implements BrokerSubscriptionConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerSubscriptionEnvironmentConfigurationProvider.class);
    private static final String BROKER_IMPLEMENTATION_PROPERTY = "BROKER_SUBSCRIPTION_IMPLEMENTATION";
    private static final String BROKER_FACTORY_METHOD_NAME = "createFromSystemProperties";

    @Override
    public BrokerSubscriptionConfiguration createSubscriptionConfiguration() throws BrokerException {
        String configurationClassName = this.readConfigurationClassName();
        try {
            LOG.debug("Instanciating Broker configuration based on environment property: {}={}", (Object)BROKER_IMPLEMENTATION_PROPERTY, (Object)configurationClassName);
            Class<?> configurationType = Class.forName(configurationClassName);
            Method method = configurationType.getMethod(BROKER_FACTORY_METHOD_NAME, new Class[0]);
            return (BrokerSubscriptionConfiguration)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            LOG.error("Class does not exist to create an instance of BrokerSubcriptionConfiguration: {}. Did you define a static method called {} ? Is this class available to the classpath?", new Object[]{configurationClassName, BROKER_FACTORY_METHOD_NAME, e});
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("An internal error occurred when creating an instance of BrokerSubcriptionConfiguration", (Throwable)e);
            if (e.getCause() instanceof BrokerException) {
                throw (BrokerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    protected String readConfigurationClassName() {
        return System.getenv(BROKER_IMPLEMENTATION_PROPERTY);
    }
}

