/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.entity;

import be.looorent.jflu.Configuration;
import be.looorent.jflu.Event;
import be.looorent.jflu.EventKind;
import be.looorent.jflu.EventMetadata;
import be.looorent.jflu.EventStatus;
import be.looorent.jflu.entity.EntityActionName;
import be.looorent.jflu.entity.EntityData;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class EntityEventFactory {
    public Event createEventOnSave(Class<?> entityType, Serializable entityId, Map<String, Object> stateByPropertyName, UUID sessionId) {
        EventMetadata metadata = this.createMetadata(entityType, EntityActionName.CREATE, sessionId);
        HashMap<String, List<Object>> changes = new HashMap<String, List<Object>>();
        for (Map.Entry<String, Object> stateAndPropertyName : stateByPropertyName.entrySet()) {
            changes.put(stateAndPropertyName.getKey(), Lists.newArrayList((Object[])new Object[]{null, stateAndPropertyName.getValue()}));
        }
        return new Event(metadata, new EntityData(entityId, entityType.getSimpleName(), EntityActionName.CREATE, null, null, changes));
    }

    public Event createEventOnDelete(Class<?> entityType, Serializable entityId, UUID sessionId) {
        EventMetadata metadata = this.createMetadata(entityType, EntityActionName.DESTROY, sessionId);
        return new Event(metadata, new EntityData(entityId, entityType.getSimpleName(), EntityActionName.DESTROY, null, null, new HashMap<String, List<Object>>()));
    }

    public Event createEventOnUpdate(Class<?> entityType, Serializable entityId, Map<String, List<Object>> changeByPropertyName, UUID sessionId) {
        EventMetadata metadata = this.createMetadata(entityType, EntityActionName.UPDATE, sessionId);
        return new Event(metadata, new EntityData(entityId, entityType.getSimpleName(), EntityActionName.CREATE, null, null, changeByPropertyName));
    }

    private EventMetadata createMetadata(Class<?> entityType, EntityActionName actionName, UUID sessionId) {
        return new EventMetadata(sessionId, actionName.name().toLowerCase() + " " + entityType.getSimpleName(), Configuration.getInstance().getEmitter(), LocalDateTime.now(), EventKind.ENTITY_CHANGE, EventStatus.NEW);
    }
}

