/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.Event;
import be.looorent.jflu.subscriber.EventMapping;
import be.looorent.jflu.subscriber.EventMappingKind;
import be.looorent.jflu.subscriber.EventMappingStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SubscriptionQuery {
    private final String emitter;
    private final EventMappingKind kind;
    private final String name;
    private final EventMappingStatus status;

    public SubscriptionQuery(EventMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("mapping must not be null");
        }
        this.emitter = mapping.emitter();
        this.kind = mapping.kind();
        this.name = mapping.name();
        this.status = mapping.status();
    }

    public SubscriptionQuery(String emitter, EventMappingKind kind, String name, EventMappingStatus status) {
        this.emitter = emitter == null ? "" : emitter;
        this.kind = kind == null ? EventMappingKind.ALL : kind;
        this.name = name == null ? "" : name;
        this.status = status == null ? EventMappingStatus.ALL : status;
    }

    public static final SubscriptionQuery exactMatchWith(Event event) {
        return new SubscriptionQuery(event.getEmitter(), EventMappingKind.valueOf(event.getKind().name()), event.getName(), EventMappingStatus.valueOf(event.getStatus().name()));
    }

    public static final SubscriptionQuery thatMatchAllEvents() {
        return new SubscriptionQuery("", EventMappingKind.ALL, "", EventMappingStatus.ALL);
    }

    public String getEmitter() {
        return this.emitter;
    }

    public EventMappingKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public EventMappingStatus getStatus() {
        return this.status;
    }

    public boolean matchesAllStatuses() {
        return this.status == EventMappingStatus.ALL;
    }

    public boolean matchesAllKinds() {
        return this.kind == EventMappingKind.ALL;
    }

    public boolean matchesAllEmitters() {
        return this.emitter.isEmpty();
    }

    public boolean matchesAllNames() {
        return this.name.isEmpty();
    }

    public SubscriptionQuery forAllKinds() {
        return new SubscriptionQuery(this.emitter, EventMappingKind.ALL, this.name, this.status);
    }

    public SubscriptionQuery forAllEmitters() {
        return new SubscriptionQuery("", this.kind, this.name, this.status);
    }

    public SubscriptionQuery forAllNames() {
        return new SubscriptionQuery(this.emitter, this.kind, "", this.status);
    }

    public SubscriptionQuery forAllStatuses() {
        return new SubscriptionQuery(this.emitter, this.kind, this.name, EventMappingStatus.ALL);
    }

    public static final Collection<SubscriptionQuery> allQueriesThatMatch(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        List<EventMappingStatus> possibleStatuses = Arrays.asList(EventMappingStatus.ALL, EventMappingStatus.valueOf(event.getStatus()));
        List<String> possibleEmitters = Arrays.asList("", event.getEmitter());
        List<EventMappingKind> possibleKinds = Arrays.asList(EventMappingKind.ALL, EventMappingKind.valueOf(event.getKind()));
        List<String> possibleNames = Arrays.asList("", event.getName());
        ArrayList<SubscriptionQuery> queries = new ArrayList<SubscriptionQuery>();
        for (EventMappingStatus status : possibleStatuses) {
            for (String emitter : possibleEmitters) {
                for (EventMappingKind kind : possibleKinds) {
                    for (String name : possibleNames) {
                        queries.add(new SubscriptionQuery(emitter, kind, name, status));
                    }
                }
            }
        }
        return queries;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubscriptionQuery)) {
            return false;
        }
        SubscriptionQuery otherQuery = (SubscriptionQuery)other;
        return Objects.equals(this.emitter, otherQuery.emitter) && Objects.equals((Object)this.kind, (Object)otherQuery.kind) && Objects.equals(this.name, otherQuery.name) && this.status == otherQuery.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.emitter, this.kind, this.name, this.status});
    }

    public String toString() {
        return "SubscriptionQuery{emitter='" + this.emitter + '\'' + ", kind=" + (Object)((Object)this.kind) + ", name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }
}

