/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.request;

import be.looorent.jflu.Configuration;
import be.looorent.jflu.Event;
import be.looorent.jflu.EventKind;
import be.looorent.jflu.EventMetadata;
import be.looorent.jflu.EventStatus;
import be.looorent.jflu.Payload;
import be.looorent.jflu.request.RequestData;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RequestEventFactory {
    private final String emitter;

    public RequestEventFactory(String emitter) {
        this.emitter = emitter;
    }

    public RequestEventFactory() {
        this(Configuration.getInstance().getEmitter());
    }

    public Event createEvent(UUID requestId, String controllerName, String actionName, String path, int responseCode, String userAgent, int duration, Map<String, List<String>> parameters, Map<String, Payload> userMetadata) {
        return new Event(this.createMetadata(controllerName + "." + actionName), new RequestData(requestId, controllerName, actionName, path, responseCode, userAgent, duration, parameters, userMetadata));
    }

    private EventMetadata createMetadata(String controllerName) {
        return new EventMetadata(UUID.randomUUID(), controllerName, this.emitter, LocalDateTime.now(ZoneOffset.UTC), EventKind.REQUEST, EventStatus.NEW);
    }
}

