/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.manual;

import be.looorent.jflu.Configuration;
import be.looorent.jflu.Event;
import be.looorent.jflu.EventKind;
import be.looorent.jflu.EventMetadata;
import be.looorent.jflu.EventStatus;
import be.looorent.jflu.manual.ManualData;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.UUID;

public class ManualEventFactory {
    private final String emitter;

    public ManualEventFactory(String emitter) {
        this.emitter = emitter;
    }

    public ManualEventFactory() {
        this(Configuration.getInstance().getEmitter());
    }

    public Event createEvent(String name, Map<String, Object> data) {
        return new Event(this.createMetadata(name), new ManualData(data));
    }

    public Event createEvent(String name, ManualData data) {
        return new Event(this.createMetadata(name), data);
    }

    private EventMetadata createMetadata(String name) {
        return new EventMetadata(UUID.randomUUID(), name, this.emitter, LocalDateTime.now(ZoneOffset.UTC), EventKind.MANUAL, EventStatus.NEW);
    }
}

