/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.entity;

import be.looorent.jflu.Configuration;
import be.looorent.jflu.Event;
import be.looorent.jflu.EventKind;
import be.looorent.jflu.EventMetadata;
import be.looorent.jflu.EventStatus;
import be.looorent.jflu.Payload;
import be.looorent.jflu.entity.EntityActionName;
import be.looorent.jflu.entity.EntityChange;
import be.looorent.jflu.entity.EntityData;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class EntityEventFactory {
    private final String emitter;

    public EntityEventFactory(String emitter) {
        this.emitter = emitter;
    }

    public EntityEventFactory() {
        this(Configuration.getInstance().getEmitter());
    }

    public Event createEventOnSave(Class<?> entityType, Serializable entityId, Map<String, Object> stateByPropertyName, UUID sessionId) {
        EventMetadata metadata = this.createMetadata(entityType, EntityActionName.CREATE, sessionId);
        HashMap<String, EntityChange> changes = new HashMap<String, EntityChange>();
        for (Map.Entry<String, Object> stateAndPropertyName : stateByPropertyName.entrySet()) {
            changes.put(stateAndPropertyName.getKey(), new EntityChange(Arrays.asList(null, new Payload(stateAndPropertyName.getValue()))));
        }
        return new Event(metadata, new EntityData(entityId, null, entityType.getSimpleName(), EntityActionName.CREATE, null, null, changes));
    }

    public Event createEventOnDelete(Class<?> entityType, Serializable entityId, UUID sessionId) {
        EventMetadata metadata = this.createMetadata(entityType, EntityActionName.DESTROY, sessionId);
        return new Event(metadata, new EntityData(entityId, null, entityType.getSimpleName(), EntityActionName.DESTROY, null, null, new HashMap<String, EntityChange>()));
    }

    public Event createEventOnUpdate(Class<?> entityType, Serializable entityId, Map<String, List<Object>> changeByPropertyName, UUID sessionId) {
        EventMetadata metadata = this.createMetadata(entityType, EntityActionName.UPDATE, sessionId);
        HashMap<String, EntityChange> changes = new HashMap<String, EntityChange>();
        for (Map.Entry<String, List<Object>> changeAndPropertyName : changeByPropertyName.entrySet()) {
            List<Payload> payloads = changeAndPropertyName.getValue().stream().map(Payload::new).collect(Collectors.toList());
            changes.put(changeAndPropertyName.getKey(), new EntityChange(payloads));
        }
        return new Event(metadata, new EntityData(entityId, null, entityType.getSimpleName(), EntityActionName.CREATE, null, null, changes));
    }

    private EventMetadata createMetadata(Class<?> entityType, EntityActionName actionName, UUID sessionId) {
        return new EventMetadata(sessionId, actionName.name().toLowerCase() + " " + entityType.getSimpleName(), this.emitter, LocalDateTime.now(ZoneOffset.UTC), EventKind.ENTITY_CHANGE, EventStatus.NEW);
    }
}

