/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu;

import be.looorent.jflu.EventData;
import be.looorent.jflu.EventKind;
import be.looorent.jflu.EventMetadata;
import be.looorent.jflu.TimestampConverter;
import be.looorent.jflu.entity.EntityData;
import be.looorent.jflu.manual.ManualData;
import be.looorent.jflu.request.RequestData;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Optional;

public class EventSerializer {

    static class EventDataDeserializer
    extends JsonDeserializer<EventData> {
        EventDataDeserializer() {
        }

        public EventData deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            EventKind kind = Optional.of(parser.getParsingContext()).map(JsonStreamContext::getParent).map(JsonStreamContext::getCurrentValue).map(EventMetadata.class::cast).map(EventMetadata::getKind).orElse(EventKind.MANUAL);
            switch (kind) {
                case ENTITY_CHANGE: {
                    return (EventData)parser.readValueAs(EntityData.class);
                }
                case REQUEST: {
                    return (EventData)parser.readValueAs(RequestData.class);
                }
            }
            return (EventData)parser.readValueAs(ManualData.class);
        }
    }

    static class TimestampDeserializer
    extends JsonDeserializer<LocalDateTime> {
        TimestampDeserializer() {
        }

        public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Optional<LocalDateTime> date = TimestampConverter.convertToLocalDateTime(parser.getValueAsString());
            return date.isPresent() ? date.get() : (LocalDateTime)parser.readValueAs(LocalDateTime.class);
        }
    }
}

