/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu;

import be.looorent.jflu.EventData;
import be.looorent.jflu.EventKind;
import be.looorent.jflu.EventMetadata;
import be.looorent.jflu.EventSerializer;
import be.looorent.jflu.EventStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

public class Event {
    @JsonProperty(value="meta")
    private final EventMetadata metadata;
    @JsonDeserialize(using=EventSerializer.EventDataDeserializer.class)
    private final EventData data;

    @JsonCreator
    public Event(@JsonProperty(value="meta") EventMetadata metadata, @JsonProperty(value="data") EventData data) {
        this.metadata = metadata;
        this.data = data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Event)) {
            return false;
        }
        Event otherEvent = (Event)other;
        return Objects.equals(this.metadata, otherEvent.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    public EventMetadata getMetadata() {
        return this.metadata;
    }

    public EventData getData() {
        return this.data;
    }

    public UUID getId() {
        return this.metadata.getId();
    }

    public String getName() {
        return this.metadata.getName();
    }

    public String getEmitter() {
        return this.metadata.getEmitter();
    }

    public LocalDateTime getTimestamp() {
        return this.metadata.getTimestamp();
    }

    public EventKind getKind() {
        return this.metadata.getKind();
    }

    public EventStatus getStatus() {
        return this.metadata.getStatus();
    }
}

