/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.subscriber;

import be.looorent.jflu.Event;
import be.looorent.jflu.subscriber.SubscriptionQuery;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription {
    private static final Logger LOG = LoggerFactory.getLogger(Subscription.class);
    private final UUID id = UUID.randomUUID();
    private final String name;
    private final SubscriptionQuery query;
    private final Consumer<Event> projector;

    public Subscription(SubscriptionQuery query, String name, Consumer<Event> projector) {
        this.query = query;
        this.name = name;
        this.projector = projector;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Subscription)) {
            return false;
        }
        Subscription otherSubscription = (Subscription)other;
        return Objects.equals(this.id, otherSubscription.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public UUID getId() {
        return this.id;
    }

    public SubscriptionQuery getQuery() {
        return this.query;
    }

    public Consumer<Event> getProjector() {
        return this.projector;
    }

    public String getName() {
        return this.name;
    }

    public void consume(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("A subscription cannot consume a null event");
        }
        LOG.debug("Consuming event {} with consumer {}", (Object)event.getId(), (Object)this.name);
        this.getProjector().accept(event);
    }
}

