/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu.entity;

import be.looorent.jflu.EventData;
import be.looorent.jflu.Payload;
import be.looorent.jflu.entity.EntityActionName;
import be.looorent.jflu.entity.EntityChange;
import be.looorent.jflu.entity.EventSerializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;

public class EntityData
implements EventData {
    @JsonDeserialize(using=EventSerializer.IdDeserializer.class)
    private final Object id;
    private final UUID requestId;
    private final String entityName;
    private final EntityActionName actionName;
    private final Map<String, Payload> userMetadata;
    private final Map<String, Object> associations;
    private final Map<String, EntityChange> changes;
    @JsonIgnore
    private final Map<String, Long> associationIds;
    @JsonIgnore
    private final Map<String, String> associationTypes;

    @JsonCreator
    public EntityData(@JsonProperty(value="entityId") Object id, @JsonProperty(value="requestId") UUID requestId, @JsonProperty(value="entityName") String entityName, @JsonProperty(value="actionName") EntityActionName actionName, @JsonProperty(value="userMetadata") Map<String, Payload> userMetadata, @JsonProperty(value="associations") Map<String, Object> associations, @JsonProperty(value="changes") Map<String, EntityChange> changes) {
        this.id = id;
        this.requestId = requestId;
        this.entityName = entityName;
        this.actionName = actionName;
        this.userMetadata = Optional.ofNullable(userMetadata).orElseGet(Collections::emptyMap);
        this.associations = Optional.ofNullable(associations).orElseGet(Collections::emptyMap);
        this.changes = changes;
        this.associationIds = Association.reduce(this.associations, x$0 -> Association.isId(x$0), x$0 -> Association.castAssociationId(x$0));
        this.associationTypes = Association.reduce(this.associations, x$0 -> Association.isType(x$0), x$0 -> Association.castAssociationType(x$0));
    }

    public Object getId() {
        return this.id;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public EntityActionName getActionName() {
        return this.actionName;
    }

    public Map<String, Payload> getUserMetadata() {
        return this.userMetadata;
    }

    public Map<String, Object> getAssociations() {
        return Collections.unmodifiableMap(this.associations);
    }

    public Map<String, Long> getAssociationIds() {
        return Collections.unmodifiableMap(this.associationIds);
    }

    public Long getAssociationId(String id) {
        return this.associationIds.get(id);
    }

    public boolean hasAssociationId(String id) {
        return this.associationIds.containsKey(id);
    }

    public Map<String, String> getAssociationTypes() {
        return Collections.unmodifiableMap(this.associationTypes);
    }

    public String getAssociationType(String typeId) {
        return this.associationTypes.get(typeId);
    }

    public boolean hasAssociationType(String typeId) {
        return this.associationTypes.containsKey(typeId);
    }

    public Map<String, EntityChange> getChanges() {
        return Collections.unmodifiableMap(this.changes);
    }

    public boolean hasChange(String name) {
        return this.changes.containsKey(name);
    }

    public <T> Optional<T> afterValueOf(String name, Class<T> clazz) {
        return Optional.ofNullable(this.changes.get(name)).flatMap(change -> change.afterValue(clazz));
    }

    public <T> Optional<T> beforeValueOf(String name, Class<T> clazz) {
        return Optional.ofNullable(this.changes.get(name)).flatMap(change -> change.afterValue(clazz));
    }

    private static class Association {
        private Association() {
        }

        private static Long castAssociationId(Object valueToCast) {
            return Optional.ofNullable(valueToCast).filter(value -> value instanceof Number).map(Number.class::cast).map(Number::longValue).orElse(null);
        }

        private static String castAssociationType(Object valueToCast) {
            return Optional.ofNullable(valueToCast).map(String::valueOf).orElse(null);
        }

        private static boolean isId(String key) {
            return key.endsWith("Id") || key.endsWith("_id");
        }

        private static boolean isType(String key) {
            return key.endsWith("Type") || key.endsWith("_type");
        }

        private static <T> Map<String, T> reduce(Map<String, Object> associations, Predicate<String> keyFilter, Function<Object, T> transformer) {
            return associations.entrySet().stream().filter(entry -> keyFilter.test((String)entry.getKey())).collect(HashMap::new, (map, entry) -> map.put(entry.getKey(), transformer.apply(entry.getValue())), Map::putAll);
        }
    }
}

