/*
 * Decompiled with CFR 0.152.
 */
package be.looorent.jflu;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class Configuration {
    private static final String EMITTER_VARIABLE = "JFLU_EMITTER";
    private static final String DEFAULT_EMITTER = "[no emitter set]";
    private static Configuration instance;
    private String emitter = System.getenv("JFLU_EMITTER");

    public Configuration() {
        if (this.emitter == null || this.emitter.isEmpty()) {
            this.emitter = DEFAULT_EMITTER;
        }
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public String getEmitter() {
        return this.emitter;
    }

    public ObjectMapper getDefaultJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        mapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }
}

